/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class PlayerFillsBucketScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerFillsBucketScriptEvent instance;
    public EntityTag entity;
    public ItemTag item;
    public MaterialTag material;
    public LocationTag location;
    public PlayerBucketFillEvent event;

    public PlayerFillsBucketScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player fills");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iTest = path.eventArgLowerAt(2);
        return (iTest.equals("bucket") || this.tryItem(this.item, iTest)) && this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerFillsBucket";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? EntityTag.getPlayerFrom((Entity)this.event.getPlayer()) : null, this.entity.isNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("material")) {
            return this.material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        this.entity = new EntityTag((Entity)event.getPlayer());
        this.location = new LocationTag(event.getBlockClicked().getLocation());
        this.item = new ItemTag(event.getItemStack());
        this.material = new MaterialTag(event.getBlockClicked());
        this.event = event;
        this.fire((Event)event);
    }
}

