/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLevelChangeEvent;

public class PlayerLevelsUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLevelsUpScriptEvent instance;
    public int new_level;
    public int old_level;
    public PlayerTag player;
    public PlayerLevelChangeEvent event;

    public PlayerLevelsUpScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player levels up");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String[] data = path.eventArgsLower;
        for (int index = 3; index < data.length; ++index) {
            if (data[index].equals("from") && ArgumentHelper.getIntegerFrom(data[index + 1]) != this.old_level) {
                return false;
            }
            if (!data[index].equals("to") || ArgumentHelper.getIntegerFrom(data[index + 1]) == this.new_level) continue;
            return false;
        }
        return this.runInCheck(path, this.player.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerLevelsUp";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("level") || name.equals("new_level")) {
            return new ElementTag(this.new_level);
        }
        if (name.equals("old_level")) {
            return new ElementTag(this.old_level);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLevels(PlayerLevelChangeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.old_level = event.getOldLevel();
        this.new_level = event.getNewLevel();
        this.event = event;
        this.fire((Event)event);
    }
}

