/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.util;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;

public class Utilities {
    private static final Random random = new Random();

    public static Location getWalkableLocationNear(Location location, int range) {
        ArrayList<Location> locations = new ArrayList<Location>();
        location = location.getBlock().getLocation();
        for (double x = (double)(-range); x <= (double)range; x += 1.0) {
            for (double y = (double)(-range); y <= (double)range; y += 1.0) {
                for (double z = (double)(-range); z <= (double)range; z += 1.0) {
                    Location loc = location.clone().add(x, y, z);
                    if (!Utilities.checkLocation(location, loc, range) || !Utilities.isWalkable(loc)) continue;
                    locations.add(loc);
                }
            }
        }
        if (locations.isEmpty()) {
            return null;
        }
        return (Location)locations.get(random.nextInt(locations.size()));
    }

    public static boolean isWalkable(Location location) {
        BlockHelper blockHelper = NMSHandler.getInstance().getBlockHelper();
        return !blockHelper.isSafeBlock(location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()) && blockHelper.isSafeBlock(location.getBlock().getType()) && blockHelper.isSafeBlock(location.clone().add(0.0, 1.0, 0.0).getBlock().getType());
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, double theLeeway) {
        if (!baseLocation.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        return baseLocation.distanceSquared(theLocation) < theLeeway * theLeeway;
    }
}

