/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class BiomeTag
implements ObjectTag,
Adjustable {
    private BiomeNMS biome;
    String prefix = "biome";
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static BiomeTag valueOf(String string) {
        return BiomeTag.valueOf(string, null);
    }

    @Fetchable(value="b")
    public static BiomeTag valueOf(String string, TagContext context) {
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(string)) continue;
            return new BiomeTag(biome);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            arg = arg.substring(2);
        }
        for (Biome b : Biome.values()) {
            if (!b.name().equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public BiomeTag(Biome biome) {
        this.biome = NMSHandler.getInstance().getBiomeNMS(biome);
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Biome";
    }

    @Override
    public String identify() {
        return "b@" + CoreUtilities.toLowerCase(this.biome.getName());
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        BiomeTag.registerTag("downfall_type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(CoreUtilities.toLowerCase(((BiomeTag)object).biome.getDownfallType().name())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        BiomeTag.registerTag("humidity", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((BiomeTag)object).biome.getHumidity()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        BiomeTag.registerTag("temperature", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((BiomeTag)object).biome.getTemperature()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        BiomeTag.registerTag("spawnable_entities", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                List<EntityType> entityTypes;
                attribute = attribute.fulfill(1);
                BiomeNMS biome = ((BiomeTag)object).biome;
                boolean hasAttribute = true;
                if (attribute.startsWith("ambient")) {
                    entityTypes = biome.getAmbientEntities();
                } else if (attribute.startsWith("creatures")) {
                    entityTypes = biome.getCreatureEntities();
                } else if (attribute.startsWith("monsters")) {
                    entityTypes = biome.getMonsterEntities();
                } else if (attribute.startsWith("water")) {
                    entityTypes = biome.getWaterEntities();
                } else {
                    entityTypes = biome.getAllEntities();
                    hasAttribute = false;
                }
                ListTag list = new ListTag();
                for (EntityType entityType : entityTypes) {
                    list.add(entityType.name());
                }
                return list.getObjectAttribute(hasAttribute ? attribute.fulfill(1) : attribute);
            }
        });
        BiomeTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Biome").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a biome!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("humidity") && mechanism.requireFloat()) {
            this.biome.setHumidity(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("temperature") && mechanism.requireFloat()) {
            this.biome.setTemperature(mechanism.getValue().asFloat());
        }
    }
}

