/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.item.ItemBook;
import com.denizenscript.denizen.objects.properties.item.ItemColor;
import com.denizenscript.denizen.objects.properties.item.ItemDurability;
import com.denizenscript.denizen.objects.properties.item.ItemFirework;
import com.denizenscript.denizen.objects.properties.item.ItemInventory;
import com.denizenscript.denizen.objects.properties.item.ItemLock;
import com.denizenscript.denizen.objects.properties.item.ItemPlantgrowth;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class ItemTag
implements ObjectTag,
Notable,
Adjustable {
    static final Pattern ITEM_PATTERN = Pattern.compile("(?:item:)?([\\w ]+)[:,]?(\\d+)?\\[?(\\d+)?\\]?", 2);
    static final Pattern item_by_saved = Pattern.compile("(i@)?(.+)\\[?(\\d+)?\\]?");
    public static final String itemscriptIdentifier = "\u00a70id:";
    private ItemStack item = null;
    private String prefix = this.getObjectType();
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static ItemTag valueOf(String string) {
        return ItemTag.valueOf(string, null);
    }

    public static ItemTag valueOf(String string, PlayerTag player, NPCTag npc) {
        return ItemTag.valueOf(string, new BukkitTagContext(player, npc, null));
    }

    public static ItemTag valueOf(String string, Debuggable debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, false, null, debugMe == null || debugMe.shouldDebug(), null));
    }

    public static ItemTag valueOf(String string, boolean debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, false, null, debugMe, null));
    }

    @Fetchable(value="i")
    public static ItemTag valueOf(String string, TagContext context) {
        block21: {
            if (string == null || string.equals("")) {
                return null;
            }
            ItemTag stack = null;
            Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
            if (m.matches()) {
                return ObjectFetcher.getObjectFrom(ItemTag.class, string, context);
            }
            m = item_by_saved.matcher(string);
            if (m.matches() && NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), ItemTag.class)) {
                stack = (ItemTag)NotableManager.getSavedObject(m.group(2));
                if (m.group(3) != null) {
                    stack.setAmount(Integer.valueOf(m.group(3)));
                }
                return stack;
            }
            m = ITEM_PATTERN.matcher(string = string.replace("i@", ""));
            if (m.matches()) {
                try {
                    if (ScriptRegistry.containsScript(m.group(1), ItemScriptContainer.class)) {
                        ItemScriptContainer isc = ScriptRegistry.getScriptContainerAs(m.group(1), ItemScriptContainer.class);
                        stack = isc.getItemFrom(context == null ? null : (BukkitTagContext)context);
                    } else if (ScriptRegistry.containsScript(m.group(1), BookScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), BookScriptContainer.class).getBookFrom(context == null ? null : (BukkitTagContext)context);
                    }
                    if (stack != null) {
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
                catch (Exception isc) {
                    // empty catch block
                }
                try {
                    String material = m.group(1).toUpperCase();
                    if (ArgumentHelper.matchesInteger(material)) {
                        if (context == null || context.debug) {
                            Deprecations.materialIds.warn();
                        }
                        stack = new ItemTag(Integer.valueOf(material));
                    } else {
                        MaterialTag mat = MaterialTag.valueOf(material);
                        stack = new ItemTag(mat.getMaterial());
                        if (mat.hasData() && NMSHandler.getVersion().isAtMost(NMSVersion.v1_12)) {
                            stack.setDurability(mat.getData().byteValue());
                        }
                    }
                    if (m.group(2) != null) {
                        stack.setDurability(Short.valueOf(m.group(2)));
                    }
                    if (m.group(3) != null) {
                        stack.setAmount(Integer.valueOf(m.group(3)));
                    }
                    return stack;
                }
                catch (Exception e) {
                    if (string.equalsIgnoreCase("none") || context != null && !context.debug) break block21;
                    Debug.log("Does not match a valid item ID or material: " + string);
                }
            }
        }
        if (context == null || context.debug) {
            Debug.log("valueOf ItemTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (CoreUtilities.toLowerCase(arg).startsWith("i@")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, ItemScriptContainer.class)) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, BookScriptContainer.class)) {
            return true;
        }
        return ItemTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public ItemTag(Material material) {
        this(new ItemStack(material));
    }

    @Deprecated
    public ItemTag(int itemId) {
        this(MaterialCompat.updateItem(itemId));
    }

    private static ItemStack fixQty(ItemStack item, int qty) {
        item.setAmount(qty);
        return item;
    }

    @Deprecated
    public ItemTag(int itemId, int qty) {
        this(ItemTag.fixQty(MaterialCompat.updateItem(itemId), qty));
    }

    public ItemTag(Material material, int qty) {
        this(new ItemStack(material, qty));
    }

    public ItemTag(MaterialTag material, int qty) {
        this.item = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) ? new ItemStack(material.getMaterial(), qty) : new ItemStack(material.getMaterial(), qty, 0, material.getData());
    }

    public ItemTag(MaterialData data) {
        this.item = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && this.item.getType().isLegacy() ? new ItemStack(Bukkit.getUnsafe().fromLegacy(data)) : data.toItemStack();
    }

    public ItemTag(ItemStack item) {
        this.item = item == null || item.getType() == Material.AIR ? new ItemStack(Material.AIR, 0) : item;
    }

    public ItemTag(Item item) {
        this(item.getItemStack());
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
    }

    public int comparesTo(ItemTag item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack compared_to) {
        if (this.item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        if (compared.getType().getId() != compared_to.getType().getId()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            if (compared_to.getItemMeta().hasDisplayName()) {
                if (!compared.getItemMeta().hasDisplayName()) {
                    return -1;
                }
                if (compared_to.getItemMeta().getDisplayName().toUpperCase().startsWith(compared.getItemMeta().getDisplayName().toUpperCase())) {
                    if (compared.getItemMeta().getDisplayName().length() > compared_to.getItemMeta().getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (compared_to.getItemMeta().hasLore()) {
                if (!compared.getItemMeta().hasLore()) {
                    return -1;
                }
                for (String string : compared_to.getItemMeta().getLore()) {
                    if (compared.getItemMeta().getLore().contains(string)) continue;
                    return -1;
                }
                if (compared.getItemMeta().getLore().size() > compared_to.getItemMeta().getLore().size()) {
                    ++determination;
                }
            }
            if (!compared_to.getItemMeta().getEnchants().isEmpty()) {
                if (compared.getItemMeta().getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : compared_to.getItemMeta().getEnchants().entrySet()) {
                    if (compared.getItemMeta().getEnchants().containsKey(entry.getKey()) && (Integer)compared.getItemMeta().getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (compared.getItemMeta().getEnchants().size() > compared_to.getItemMeta().getEnchants().size()) {
                    ++determination;
                }
            }
        }
        if (this.isRepairable()) {
            if (compared.getDurability() < compared_to.getDurability()) {
                ++determination;
            }
        } else if (this.getItemStack().getData().getData() != this.item.getData().getData()) {
            return -1;
        }
        return determination;
    }

    public void setStackSize(int size) {
        this.getItemStack().setAmount(size);
    }

    public boolean containsLore(String prefix) {
        if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
            for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                if (!itemLore.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLore(String prefix) {
        for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
            if (!itemLore.startsWith(prefix)) continue;
            return itemLore.substring(prefix.length());
        }
        return "";
    }

    public boolean isItemscript() {
        return ItemScriptHelper.isItemscript(this.item);
    }

    public String getScriptName() {
        ItemScriptContainer cont = ItemScriptHelper.getItemScriptContainer(this.item);
        if (cont != null) {
            return cont.getName();
        }
        return null;
    }

    public void setItemScript(ItemScriptContainer script) {
        if (script.contains("NO_ID") && Boolean.valueOf(script.getString("NO_ID")).booleanValue()) {
            return;
        }
        if (Settings.packetInterception()) {
            this.setItemStack(NMSHandler.getItemHelper().addNbtData(this.getItemStack(), "Denizen Item Script", new StringTag(script.getHashID())));
        } else {
            ItemMeta meta = this.item.getItemMeta();
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            lore.add(0, script.getHashID());
            meta.setLore(lore);
            this.item.setItemMeta(meta);
        }
    }

    public MaterialTag getMaterial() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return new MaterialTag(this.getItemStack().getType());
        }
        return OldMaterialsHelper.getMaterialFrom(this.getItemStack().getType(), this.getItemStack().getData().getData());
    }

    public String getMaterialName() {
        return CoreUtilities.toLowerCase(this.getItemStack().getType().name());
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public int getMaxStackSize() {
        return this.item.getMaxStackSize();
    }

    public int getAmount() {
        if (this.item != null) {
            return this.item.getAmount();
        }
        return 0;
    }

    public void setDurability(short value) {
        if (this.item != null) {
            this.item.setDurability(value);
        }
    }

    public void setData(byte value) {
        if (this.item != null) {
            this.item.getData().setData(value);
        }
    }

    public boolean isRepairable() {
        return this.item.getType().getMaxDurability() > 0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ItemTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getObjectType() {
        return "Item";
    }

    @Override
    public String identify() {
        if (this.item == null || this.item.getType() == Material.AIR) {
            return "i@air";
        }
        if (this.isUnique()) {
            return "i@" + NotableManager.getSavedId(this) + PropertyParser.getPropertiesString(this);
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && (this.item.getDurability() >= 16 || this.item.getDurability() < 0) && this.item.getType() != Material.AIR) {
            return "i@" + this.getMaterial().realName() + "," + this.item.getDurability() + PropertyParser.getPropertiesString(this);
        }
        return "i@" + this.getMaterial().identifyNoPropertiesNoIdentifier().replace("m@", "") + PropertyParser.getPropertiesString(this);
    }

    @Override
    public String identifySimple() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getType() != Material.AIR) {
            if (this.isUnique()) {
                return "i@" + NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return "i@" + this.getScriptName();
            }
        }
        return "i@" + this.identifyMaterial().replace("m@", "");
    }

    public String identifyMaterial() {
        return this.getMaterial().identifySimple();
    }

    public String identifyMaterialNoIdentifier() {
        return this.getMaterial().identifySimpleNoIdentifier();
    }

    public String getFullString() {
        return "i@" + this.getMaterial().realName() + "," + this.item.getDurability() + PropertyParser.getPropertiesString(this);
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Items")
    public String getSaveObject() {
        return this.getFullString();
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    public static void registerTags() {
        ItemTag.registerTag("id", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Deprecations.materialIds.warn(attribute.getScriptEntry());
                return new ElementTag(((ItemTag)object).getItemStack().getType().getId()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("data", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Deprecations.materialIds.warn(attribute.getScriptEntry());
                return new ElementTag(((ItemTag)object).getItemStack().getData().getData()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("with", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("ItemTag.with[...] tag must have an input mechanism list.");
                }
                ItemTag item = new ItemTag(((ItemTag)object).getItemStack().clone());
                List<String> properties = ObjectFetcher.separateProperties("[" + attribute.getContext(1) + "]");
                for (int i = 1; i < properties.size(); ++i) {
                    List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
                    if (data.size() != 2) {
                        Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                        continue;
                    }
                    item.safeApplyProperty(new Mechanism(new ElementTag(data.get(0)), new ElementTag(data.get(1).replace('\u2011', ';')), attribute.context));
                }
                return item.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("repairable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemDurability.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_crop", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemPlantgrowth.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_book", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemBook.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_colorable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemColor.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_dyeable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemColor.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_firework", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemFirework.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("has_inventory", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemInventory.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("is_lockable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(ItemLock.describes(object)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("material", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.getAttribute(2).equals("formatted")) {
                    return object.getObjectAttribute(attribute.fulfill(1));
                }
                ItemTag item = (ItemTag)object;
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta() instanceof BlockStateMeta) {
                    return new MaterialTag(new ModernBlockData(((BlockStateMeta)item.getItemStack().getItemMeta()).getBlockState())).getObjectAttribute(attribute.fulfill(1));
                }
                return item.getMaterial().getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("json", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(NMSHandler.getItemHelper().getJsonString(((ItemTag)object).item)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("bukkit_serial", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                YamlConfiguration config = new YamlConfiguration();
                config.set("item", (Object)((ItemTag)object).getItemStack());
                return new ElementTag(config.saveToString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("full", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ItemTag)object).getFullString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("simple", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ItemTag)object).identifySimple()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("recipe_ids", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String type = attribute.hasContext(1) ? CoreUtilities.toLowerCase(attribute.getContext(1)) : null;
                ItemTag item = (ItemTag)object;
                ItemScriptContainer container = item.isItemscript() ? ItemScriptHelper.getItemScriptContainer(item.getItemStack()) : null;
                ListTag list = new ListTag();
                for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)item.getItemStack())) {
                    NamespacedKey key;
                    if (!Utilities.isRecipeOfType(recipe, type) || !(recipe instanceof Keyed) || ((key = ((Keyed)recipe).getKey()).getNamespace().equalsIgnoreCase("denizen") ? container != ItemScriptHelper.recipeIdToItemScript.get(key.toString()) : container != null)) continue;
                    list.add(key.toString());
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("notable_name", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String notname = NotableManager.getSavedId((ItemTag)object);
                if (notname == null) {
                    return null;
                }
                return new ElementTag(notname).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("formatted", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String id = CoreUtilities.toLowerCase(((ItemTag)object).getMaterial().realName()).replace('_', ' ');
                if (id.equals("air")) {
                    return new ElementTag("nothing").getObjectAttribute(attribute.fulfill(1));
                }
                if (id.equals("ice") || id.equals("dirt")) {
                    return new ElementTag(id).getObjectAttribute(attribute.fulfill(1));
                }
                if (((ItemTag)object).getItemStack().getAmount() > 1) {
                    if (id.equals("cactus")) {
                        return new ElementTag("cactuses").getObjectAttribute(attribute.fulfill(1));
                    }
                    if (id.endsWith(" off")) {
                        id = id.substring(0, id.length() - 4);
                    }
                    if (id.endsWith(" on")) {
                        id = id.substring(0, id.length() - 3);
                    }
                    if (id.equals("rotten flesh") || id.equals("cooked fish") || id.equals("raw fish") || id.endsWith("s")) {
                        return new ElementTag(id).getObjectAttribute(attribute.fulfill(1));
                    }
                    if (id.endsWith("y")) {
                        return new ElementTag(id.substring(0, id.length() - 1) + "ies").getObjectAttribute(attribute.fulfill(1));
                    }
                    if (id.endsWith("sh") || id.endsWith("ch")) {
                        return new ElementTag(id + "es").getObjectAttribute(attribute.fulfill(1));
                    }
                    return new ElementTag(id + "s").getObjectAttribute(attribute.fulfill(1));
                }
                if (id.equals("cactus")) {
                    return new ElementTag("a cactus").getObjectAttribute(attribute.fulfill(1));
                }
                if (id.endsWith("s")) {
                    return new ElementTag(id).getObjectAttribute(attribute.fulfill(1));
                }
                if (id.endsWith(" off")) {
                    return new ElementTag("a " + id.substring(0, id.length() - 4)).getObjectAttribute(attribute.fulfill(1));
                }
                if (id.endsWith(" on")) {
                    return new ElementTag("a " + id.substring(0, id.length() - 3)).getObjectAttribute(attribute.fulfill(1));
                }
                if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                    return new ElementTag("an " + id).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag("a " + id).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ItemTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Item").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

