/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.TippedArrow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityPotionEffects
implements Property {
    public static final String[] handledTags = new String[]{"list_effects", "has_effect"};
    public static final String[] handledMechs = new String[]{"potion_effects"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        return object instanceof EntityTag && (((EntityTag)object).isLivingEntity() || ((EntityTag)object).getBukkitEntity() instanceof TippedArrow);
    }

    public static EntityPotionEffects getFrom(ObjectTag object) {
        if (!EntityPotionEffects.describes(object)) {
            return null;
        }
        return new EntityPotionEffects((EntityTag)object);
    }

    private EntityPotionEffects(EntityTag entity) {
        this.entity = entity;
    }

    public Collection<PotionEffect> getEffectsList() {
        if (this.entity.isLivingEntity()) {
            return this.entity.getLivingEntity().getActivePotionEffects();
        }
        if (this.entity.getBukkitEntity() instanceof TippedArrow) {
            return ((TippedArrow)this.entity.getBukkitEntity()).getCustomEffects();
        }
        return new ArrayList<PotionEffect>();
    }

    @Override
    public String getPropertyString() {
        Collection<PotionEffect> effects = this.getEffectsList();
        if (effects.isEmpty()) {
            return null;
        }
        ListTag returnable = new ListTag();
        for (PotionEffect effect : effects) {
            returnable.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration());
        }
        return returnable.identify().substring(3);
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    public static String stringify(PotionEffect effect) {
        return effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "," + effect.isAmbient() + "," + effect.hasParticles() + (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) ? "," + effect.hasIcon() : "");
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("list_effects")) {
            ListTag effects = new ListTag();
            for (PotionEffect effect : this.getEffectsList()) {
                effects.add(EntityPotionEffects.stringify(effect));
            }
            return effects.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            boolean returnElement = false;
            if (attribute.hasContext(1)) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getContext(1));
                for (PotionEffect effect : this.getEffectsList()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    returnElement = true;
                }
            } else if (!this.getEffectsList().isEmpty()) {
                returnElement = true;
            }
            return new ElementTag(returnElement).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            ListTag effects = ListTag.valueOf(mechanism.getValue().asString());
            for (String effect : effects) {
                List<String> split = CoreUtilities.split(effect, ',');
                if (split.size() < 3) continue;
                PotionEffectType effectType = PotionEffectType.getByName((String)split.get(0));
                if (effectType == null) {
                    Debug.echoError("Cannot apply potion effect '" + split.get(0) + "': unknown effect type.");
                    continue;
                }
                try {
                    PotionEffect actualEffect = split.size() >= 6 ? new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue(), split.get(3).equalsIgnoreCase("true"), split.get(4).equalsIgnoreCase("true"), split.get(5).equalsIgnoreCase("true")) : (split.size() >= 5 ? new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue(), split.get(3).equalsIgnoreCase("true"), split.get(4).equalsIgnoreCase("true")) : new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue()));
                    if (this.entity.isLivingEntity()) {
                        this.entity.getLivingEntity().addPotionEffect(actualEffect);
                        continue;
                    }
                    if (!(this.entity.getBukkitEntity() instanceof TippedArrow)) continue;
                    ((TippedArrow)this.entity.getBukkitEntity()).addCustomEffect(actualEffect, true);
                }
                catch (NumberFormatException ex) {
                    Debug.echoError("Cannot apply potion effect '" + effect + "': invalid amplifier or duration number.");
                }
            }
        }
    }
}

