/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class EntityVisible
implements Property {
    public static final String[] handledTags = new String[]{"visible"};
    public static final String[] handledMechs = new String[]{"visible"};
    EntityTag entity;
    ArmorStand stand;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.ARMOR_STAND;
    }

    public static EntityVisible getFrom(ObjectTag entity) {
        if (!EntityVisible.describes(entity)) {
            return null;
        }
        return new EntityVisible((EntityTag)entity);
    }

    private EntityVisible(EntityTag ent) {
        this.entity = ent;
        this.stand = (ArmorStand)ent.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        if (!((ArmorStand)this.entity.getBukkitEntity()).isVisible()) {
            return "false";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "visible";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("visible")) {
            return new ElementTag(this.stand.isVisible()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("visible") && mechanism.requireBoolean()) {
            if (Depends.citizens != null) {
                InvisibleTrait.setInvisible((LivingEntity)this.stand, CitizensAPI.getNPCRegistry().getNPC((Entity)this.stand), !mechanism.getValue().asBoolean());
            } else {
                this.stand.setVisible(mechanism.getValue().asBoolean());
            }
        }
    }
}

