/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.data.Lightable;

public class MaterialLightable
implements Property {
    public static final String[] handledTags = new String[]{"lit"};
    public static final String[] handledMechs = new String[]{"lit"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof Lightable;
    }

    public static MaterialLightable getFrom(ObjectTag _material) {
        if (!MaterialLightable.describes(_material)) {
            return null;
        }
        return new MaterialLightable((MaterialTag)_material);
    }

    private MaterialLightable(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("lit")) {
            return new ElementTag(this.getLightable().isLit()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Lightable getLightable() {
        return (Lightable)this.material.getModernData().data;
    }

    @Override
    public String getPropertyString() {
        return this.getLightable().isLit() ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "lit";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("lit") && mechanism.requireBoolean()) {
            this.getLightable().setLit(mechanism.getValue().asBoolean());
        }
    }
}

