/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.trade;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class TradeResult
implements Property {
    public static final String[] handledTags = new String[]{"result"};
    public static final String[] handledMechs = new String[]{"result"};
    private TradeTag recipe;

    public static boolean describes(ObjectTag recipe) {
        return recipe instanceof TradeTag;
    }

    public static TradeResult getFrom(ObjectTag recipe) {
        if (!TradeResult.describes(recipe)) {
            return null;
        }
        return new TradeResult((TradeTag)recipe);
    }

    public TradeResult(TradeTag recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPropertyString() {
        if (this.recipe.getRecipe() == null) {
            return null;
        }
        return new ItemTag(this.recipe.getRecipe().getResult()).identify();
    }

    @Override
    public String getPropertyId() {
        return "result";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("result")) {
            return new ItemTag(this.recipe.getRecipe().getResult()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("result") && mechanism.requireObject(ItemTag.class)) {
            ItemStack item = mechanism.valueAsType(ItemTag.class).getItemStack();
            MerchantRecipe oldRecipe = this.recipe.getRecipe();
            MerchantRecipe newRecipe = new MerchantRecipe(item, oldRecipe.getUses(), oldRecipe.getMaxUses(), oldRecipe.hasExperienceReward());
            newRecipe.setIngredients(oldRecipe.getIngredients());
            this.recipe.setRecipe(newRecipe);
        }
    }
}

