/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class EconomyScriptContainer
extends ScriptContainer {
    public static List<DenizenEconomyProvider> providersRegistered = new ArrayList<DenizenEconomyProvider>();

    public ServicePriority getPriority() {
        String prioString = CoreUtilities.toLowerCase(this.getString("PRIORITY", "normal"));
        for (ServicePriority prio : ServicePriority.values()) {
            if (!CoreUtilities.toLowerCase(prio.name()).equals(prioString)) continue;
            return prio;
        }
        return ServicePriority.Normal;
    }

    public DenizenEconomyProvider register() {
        DenizenEconomyProvider provider = new DenizenEconomyProvider();
        provider.backingScript = this;
        Bukkit.getServer().getServicesManager().register(Economy.class, (Object)provider, (Plugin)DenizenAPI.getCurrentInstance(), this.getPriority());
        return provider;
    }

    public static void cleanup() {
        for (DenizenEconomyProvider provider : providersRegistered) {
            Bukkit.getServer().getServicesManager().unregister((Object)provider);
        }
        providersRegistered.clear();
    }

    public EconomyScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        providersRegistered.add(this.register());
    }

    public static class DenizenEconomyProvider
    extends AbstractEconomy {
        public EconomyScriptContainer backingScript;

        public String autoTagAmount(String value, OfflinePlayer player, double amount) {
            return this.autoTag(value.replace("<amount", "<element[" + amount + "]"), player);
        }

        public String autoTag(String value, OfflinePlayer player) {
            if (value == null) {
                return null;
            }
            return TagManager.tag(value, new BukkitTagContext(player == null ? null : new PlayerTag(player), null, new ScriptTag(this.backingScript)));
        }

        public String runSubScript(String pathName, OfflinePlayer player, double amount) {
            List<ScriptEntry> entries = this.backingScript.getEntries(new BukkitScriptEntryData(new PlayerTag(player), null), pathName);
            InstantQueue queue = new InstantQueue(this.backingScript.getName());
            queue.addEntries(entries);
            queue.addDefinition("amount", new ElementTag(amount));
            queue.start();
            if (queue.determinations != null && queue.determinations.size() > 0) {
                return (String)queue.determinations.get(0);
            }
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return this.backingScript.getName();
        }

        public boolean hasBankSupport() {
            return false;
        }

        public int fractionalDigits() {
            return ArgumentHelper.getIntegerFrom(this.backingScript.getString("digits", "2"));
        }

        public String format(double amount) {
            return this.autoTagAmount(this.backingScript.getString("format"), null, amount);
        }

        public String currencyNamePlural() {
            return this.backingScript.getString("name plural", "moneys");
        }

        public String currencyNameSingular() {
            return this.backingScript.getString("name single", "money");
        }

        public double getBalance(OfflinePlayer player) {
            return ArgumentHelper.getDoubleFrom(this.autoTag(this.backingScript.getString("balance"), player));
        }

        public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
            String determination = this.runSubScript("withdraw", player, amount);
            return new EconomyResponse(amount, this.getBalance(player), determination == null ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, determination);
        }

        public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
            String determination = this.runSubScript("deposit", player, amount);
            return new EconomyResponse(amount, this.getBalance(player), determination == null ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, determination);
        }

        public boolean has(OfflinePlayer player, double amount) {
            return ArgumentHelper.getBooleanFrom(this.autoTagAmount(this.backingScript.getString("has"), player, amount));
        }

        public boolean hasAccount(String playerName) {
            return true;
        }

        public boolean hasAccount(String playerName, String worldName) {
            return true;
        }

        public double getBalance(String playerName) {
            return this.getBalance((OfflinePlayer)Bukkit.getPlayerExact((String)playerName));
        }

        public double getBalance(String playerName, String worldName) {
            return this.getBalance(playerName);
        }

        public double getBalance(OfflinePlayer player, String worldName) {
            return this.getBalance(player);
        }

        public boolean has(String playerName, double amount) {
            return this.has((OfflinePlayer)Bukkit.getPlayerExact((String)playerName), amount);
        }

        public boolean has(String playerName, String worldName, double amount) {
            return this.has(playerName, amount);
        }

        public boolean has(OfflinePlayer player, String worldName, double amount) {
            return this.has(player, amount);
        }

        public EconomyResponse withdrawPlayer(String playerName, double amount) {
            return this.withdrawPlayer((OfflinePlayer)Bukkit.getPlayerExact((String)playerName), amount);
        }

        public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
            return this.withdrawPlayer(playerName, amount);
        }

        public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
            return this.withdrawPlayer(player, amount);
        }

        public EconomyResponse depositPlayer(String playerName, double amount) {
            return this.depositPlayer((OfflinePlayer)Bukkit.getPlayerExact((String)playerName), amount);
        }

        public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
            return this.depositPlayer(playerName, amount);
        }

        public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
            return this.depositPlayer(player, amount);
        }

        public EconomyResponse createBank(String s, String s1) {
            return null;
        }

        public EconomyResponse deleteBank(String s) {
            return null;
        }

        public EconomyResponse bankBalance(String s) {
            return null;
        }

        public EconomyResponse bankHas(String s, double v) {
            return null;
        }

        public EconomyResponse bankWithdraw(String s, double v) {
            return null;
        }

        public EconomyResponse bankDeposit(String s, double v) {
            return null;
        }

        public EconomyResponse isBankOwner(String s, String s1) {
            return null;
        }

        public EconomyResponse isBankMember(String s, String s1) {
            return null;
        }

        public List<String> getBanks() {
            return null;
        }

        public boolean createPlayerAccount(String s) {
            return false;
        }

        public boolean createPlayerAccount(String s, String s1) {
            return false;
        }
    }
}

