/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.nbt.LeatherColorer;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    public boolean bound = false;
    String hash = "";
    private ItemTag cleanReference;
    boolean isProcessing = false;

    public ItemScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        ItemScriptHelper.item_scripts_by_hash_id.put(ItemScriptHelper.createItemScriptID(this), this);
    }

    public ItemTag getCleanReference() {
        if (this.cleanReference == null) {
            this.cleanReference = this.getItemFrom();
        }
        return new ItemTag(this.cleanReference.getItemStack().clone());
    }

    public String getHashID() {
        return this.hash;
    }

    public void setHashID(String HashID) {
        this.hash = HashID;
    }

    public ItemTag getItemFrom() {
        return this.getItemFrom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemTag getItemFrom(BukkitTagContext context) {
        if (this.isProcessing) {
            Debug.echoError("Item script contains (or chains to) a reference to itself. Cannot process.");
            return null;
        }
        if (context == null) {
            context = new BukkitTagContext(null, null, new ScriptTag(this));
        }
        ItemTag stack = null;
        this.isProcessing = true;
        try {
            ItemMeta meta;
            List lore;
            String material;
            if (this.contains("MATERIAL")) {
                material = TagManager.tag(this.getString("MATERIAL"), context);
                if (material.startsWith("m@")) {
                    material = material.substring(2);
                }
                stack = ItemTag.valueOf(material, this);
            }
            if (stack == null) {
                material = null;
                return material;
            }
            if (this.contains("MECHANISMS")) {
                YamlConfiguration mechs = this.getConfigurationSection("MECHANISMS");
                for (StringHolder key : mechs.getKeys(false)) {
                    String val;
                    if (mechs.isList(key.str)) {
                        ListTag list = new ListTag();
                        for (String listVal : mechs.getStringList(key.str)) {
                            list.add(ScriptBuilder.stripLinePrefix(TagManager.tag(listVal, context)));
                        }
                        val = list.identify();
                    } else {
                        val = TagManager.tag(mechs.getString(key.str), context);
                    }
                    stack.safeAdjust(new Mechanism(new ElementTag(key.low), new ElementTag(val), context));
                }
            }
            List list = lore = (meta = stack.getItemStack().getItemMeta()).hasLore() ? meta.getLore() : new ArrayList();
            if (this.contains("DISPLAY NAME")) {
                String displayName = TagManager.tag(this.getString("DISPLAY NAME"), context);
                meta.setDisplayName(displayName);
            }
            if (this.contains("BOUND")) {
                Deprecations.boundWarning.warn(context);
                this.bound = Boolean.valueOf(TagManager.tag(this.getString("BOUND"), context));
            }
            if (this.contains("LORE")) {
                for (String l : this.getStringList("LORE")) {
                    l = TagManager.tag(l, context);
                    lore.add(l);
                }
            }
            meta.setLore(lore);
            stack.getItemStack().setItemMeta(meta);
            if (this.contains("DURABILITY")) {
                short durability = Short.valueOf(this.getString("DURABILITY"));
                stack.setDurability(durability);
            }
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    enchantment = TagManager.tag(enchantment, context);
                    try {
                        int level = 1;
                        String[] split = enchantment.split(":");
                        if (split.length > 1) {
                            level = Integer.valueOf(split[1].replace(" ", ""));
                            enchantment = split[0].replace(" ", "");
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.getItemStack().addUnsafeEnchantment(ench, level);
                    }
                    catch (Exception e) {
                        Debug.echoError("While constructing '" + this.getName() + "', encountered error: '" + enchantment + "' is an invalid enchantment!");
                    }
                }
            }
            if (this.contains("COLOR")) {
                String color = TagManager.tag(this.getString("COLOR"), context);
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = (BookScriptContainer)ScriptRegistry.getScriptContainer(TagManager.tag(this.getString("BOOK"), context).replace("s@", ""));
                stack = book.writeBookTo(stack, context);
            }
            stack.setItemScript(this);
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this item script!");
            Debug.echoError(e);
            stack = null;
        }
        finally {
            this.isProcessing = false;
        }
        return stack;
    }
}

