/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.DenizenMapRenderer;
import com.denizenscript.denizen.utilities.maps.MapAnimatedImage;
import com.denizenscript.denizen.utilities.maps.MapCursor;
import com.denizenscript.denizen.utilities.maps.MapDot;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.maps.MapText;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.map.MapView;

public class MapScriptContainer
extends ScriptContainer {
    public MapScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public void applyTo(MapView mapView) {
        DenizenMapRenderer renderer = new DenizenMapRenderer(mapView.getRenderers(), ArgumentHelper.getBooleanFrom(this.getString("AUTO UPDATE", "true")));
        boolean debug = true;
        if (this.contains("ORIGINAL")) {
            renderer.displayOriginal = ArgumentHelper.getBooleanFrom(this.getString("ORIGINAL"));
        }
        if (this.contains("DEBUG")) {
            debug = ArgumentHelper.getBooleanFrom(this.getString("DEBUG"));
        }
        if (this.contains("OBJECTS")) {
            YamlConfiguration objectsSection = this.getConfigurationSection("OBJECTS");
            ArrayList<StringHolder> objectKeys1 = new ArrayList<StringHolder>(objectsSection.getKeys(false));
            ArrayList<String> objectKeys = new ArrayList<String>(objectKeys1.size());
            for (StringHolder sh : objectKeys1) {
                objectKeys.add(sh.str);
            }
            Collections.sort(objectKeys, new NaturalOrderComparator());
            for (String objectKey : objectKeys) {
                boolean worldC;
                YamlConfiguration objectSection = objectsSection.getConfigurationSection(objectKey);
                if (!objectSection.contains("TYPE")) {
                    Debug.echoError("Map script '" + this.getName() + "' has an object without a specified type!");
                    return;
                }
                String type = objectSection.getString("TYPE").toUpperCase();
                String x = objectSection.getString("X", "0");
                String y = objectSection.getString("Y", "0");
                String visible = objectSection.getString("VISIBLE", "true");
                boolean bl = worldC = objectSection.contains("WORLD_COORDINATES") && ArgumentHelper.getBooleanFrom(objectSection.getString("WORLD_COORDINATES", "false"));
                if (type.equals("IMAGE")) {
                    if (!objectSection.contains("IMAGE")) {
                        Debug.echoError("Map script '" + this.getName() + "'s image '" + objectKey + "' has no specified image location!");
                        return;
                    }
                    String image = objectSection.getString("IMAGE");
                    int width = ArgumentHelper.getIntegerFrom(objectSection.getString("WIDTH", "0"));
                    int height = ArgumentHelper.getIntegerFrom(objectSection.getString("HEIGHT", "0"));
                    if (CoreUtilities.toLowerCase(image).endsWith(".gif")) {
                        renderer.addObject(new MapAnimatedImage(x, y, visible, debug, image, width, height));
                    } else {
                        renderer.addObject(new MapImage(x, y, visible, debug, image, width, height));
                    }
                } else if (type.equals("TEXT")) {
                    if (!objectSection.contains("TEXT")) {
                        Debug.echoError("Map script '" + this.getName() + "'s text object '" + objectKey + "' has no specified text!");
                        return;
                    }
                    String text = objectSection.getString("TEXT");
                    renderer.addObject(new MapText(x, y, visible, debug, text));
                } else if (type.equals("CURSOR")) {
                    if (!objectSection.contains("CURSOR")) {
                        Debug.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' has no specified cursor type!");
                        return;
                    }
                    String cursor = objectSection.getString("CURSOR");
                    if (cursor == null) {
                        Debug.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' is missing a cursor type!");
                        return;
                    }
                    renderer.addObject(new MapCursor(x, y, visible, debug, objectSection.getString("DIRECTION", "0"), cursor));
                } else if (type.equals("DOT")) {
                    renderer.addObject(new MapDot(x, y, visible, debug, objectSection.getString("RADIUS", "1"), objectSection.getString("COLOR", "black")));
                } else {
                    Debug.echoError("Weird map data!");
                }
                if (!worldC || renderer.mapObjects.size() <= 0) continue;
                renderer.mapObjects.get((int)(renderer.mapObjects.size() - 1)).worldCoordinates = true;
            }
        }
        DenizenMapManager.setMap(mapView, renderer);
    }
}

