/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;

public class PistonExtendsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PistonExtendsScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public BlockPistonExtendEvent event;

    public PistonExtendsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("extends");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(0);
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!mat.equals("piston") && !this.tryMaterial(this.material, mat)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PistonExtends";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("sticky")) {
            return new ElementTag(this.event.isSticky());
        }
        if (name.equals("relative")) {
            return new LocationTag(this.event.getBlock().getRelative(this.event.getDirection()).getLocation());
        }
        if (name.equals("blocks")) {
            ListTag blocks = new ListTag();
            for (Block block : this.event.getBlocks()) {
                blocks.addObject(new LocationTag(block.getLocation()));
            }
            return blocks;
        }
        if (name.equals("length")) {
            return new ElementTag(this.event.getBlocks().size());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPistonExtends(BlockPistonExtendEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

