/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityDeathScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDeathScriptEvent instance;
    public EntityTag entity;
    public EntityTag damager;
    public ElementTag message;
    public InventoryTag inventory;
    public ElementTag cause;
    public ListTag drops;
    public List<ItemTag> dropItems;
    public Integer xp;
    public boolean keep_inv;
    public boolean keep_level;
    public EntityDeathEvent event;

    public EntityDeathScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        return cmd.equals("dies") || cmd.equals("death");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (path.switches.containsKey("by") && (this.damager == null || !this.tryEntity(this.damager, path.switches.get("by")))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityDies";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("drops ")) {
            lower = lower.substring(6);
            determination = determination.substring(6);
        }
        if (lower.startsWith("no_drops")) {
            this.drops.clear();
            this.dropItems = new ArrayList<ItemTag>();
            if (lower.endsWith("_or_xp")) {
                this.xp = 0;
            }
        } else if (lower.equals("no_xp")) {
            this.xp = 0;
        } else if (lower.equals("keep_inv")) {
            this.keep_inv = true;
        } else if (lower.equals("keep_level")) {
            this.keep_level = true;
        } else if (ArgumentHelper.matchesInteger(determination)) {
            this.xp = Argument.valueOf(lower).asElement().asInt();
        } else if (Argument.valueOf(lower).matchesArgumentList(ItemTag.class)) {
            this.drops.clear();
            this.dropItems = new ArrayList<ItemTag>();
            ListTag drops_list = ListTag.valueOf(determination);
            drops_list.filter(ItemTag.class, path.container, true);
            for (String drop : drops_list) {
                ItemTag item = ItemTag.valueOf(drop, path.container);
                if (item == null) continue;
                this.dropItems.add(item);
                this.drops.add(item.identify());
            }
        } else if (this.event instanceof PlayerDeathEvent && !EntityDeathScriptEvent.isDefaultDetermination(determinationObj)) {
            this.message = new ElementTag(determination);
        } else {
            return super.applyDetermination(path, determinationObj);
        }
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager.getDenizenObject();
        }
        if (name.equals("message") && this.message != null) {
            return this.message;
        }
        if (name.equals("inventory") && this.inventory != null) {
            return this.inventory;
        }
        if (name.equals("cause") && this.cause != null) {
            return this.cause;
        }
        if (name.equals("drops") && this.drops != null) {
            return this.drops;
        }
        if (name.equals("xp") && this.xp != null) {
            return new ElementTag(this.xp);
        }
        return super.getContext(name);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        EntityTag.rememberEntity((Entity)livingEntity);
        this.entity = new EntityTag((Entity)livingEntity);
        PlayerTag player = null;
        if (this.entity.isPlayer()) {
            player = this.entity.getDenizenPlayer();
        }
        this.cause = null;
        this.damager = null;
        EntityDamageEvent lastDamage = this.entity.getBukkitEntity().getLastDamageCause();
        if (lastDamage != null) {
            this.cause = new ElementTag(event.getEntity().getLastDamageCause().getCause().toString());
            if (lastDamage instanceof EntityDamageByEntityEvent) {
                EntityTag damageEntity = new EntityTag(((EntityDamageByEntityEvent)lastDamage).getDamager());
                EntityTag shooter = damageEntity.getShooter();
                this.damager = shooter != null ? shooter : damageEntity;
            } else if (livingEntity.getKiller() != null) {
                this.damager = new EntityTag((Entity)livingEntity.getKiller());
            }
        }
        this.message = null;
        this.inventory = null;
        PlayerDeathEvent subEvent = null;
        if (event instanceof PlayerDeathEvent) {
            subEvent = (PlayerDeathEvent)event;
            this.message = new ElementTag(subEvent.getDeathMessage());
            if (player != null) {
                this.inventory = player.getInventory();
            }
            this.keep_inv = subEvent.getKeepInventory();
            this.keep_level = subEvent.getKeepLevel();
        }
        this.drops = new ListTag();
        for (ItemStack stack : event.getDrops()) {
            this.drops.addObject(new ItemTag(stack == null ? new ItemStack(Material.AIR) : stack));
        }
        this.cancelled = false;
        this.dropItems = null;
        this.xp = event.getDroppedExp();
        this.event = event;
        this.fire((Event)event);
        event.setDroppedExp(this.xp.intValue());
        if (this.dropItems != null) {
            event.getDrops().clear();
            for (ItemTag drop : this.dropItems) {
                if (drop == null) continue;
                event.getDrops().add(drop.getItemStack());
            }
        }
        if (subEvent != null) {
            subEvent.setKeepInventory(this.keep_inv);
            subEvent.setKeepLevel(this.keep_level);
            if (this.message != null) {
                subEvent.setDeathMessage(this.message.asString());
            }
            if (this.cancelled) {
                subEvent.setDeathMessage(null);
            }
        }
        EntityTag.forgetEntity((Entity)livingEntity);
    }
}

