/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public class HangingBreaksScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HangingBreaksScriptEvent instance;
    public ElementTag cause;
    public EntityTag entity;
    public EntityTag hanging;
    public HangingBreakEvent event;

    public HangingBreaksScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.getXthArg(1, lower).equals("breaks") && !CoreUtilities.getXthArg(2, lower).equals("hanging") && !CoreUtilities.getXthArg(0, lower).equals("player");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String hangCheck = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.hanging, hangCheck)) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equals(CoreUtilities.toLowerCase(this.cause.asString()))) {
            return false;
        }
        if (!this.runInCheck(path, this.hanging.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "HangingBreaks";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity != null && this.entity.isPlayer() ? EntityTag.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity != null && this.entity.isCitizensNPC() ? EntityTag.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("cause")) {
            return this.cause;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("hanging")) {
            return this.hanging;
        }
        if (name.equals("location")) {
            Deprecations.hangingBreaksEventContext.warn();
            return this.hanging.getLocation();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakEvent event) {
        this.hanging = new EntityTag((Entity)event.getEntity());
        this.cause = new ElementTag(event.getCause().name());
        this.entity = event instanceof HangingBreakByEntityEvent ? new EntityTag(((HangingBreakByEntityEvent)event).getRemover()) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

