/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDamageEvent;

public class VehicleDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleDamagedScriptEvent instance;
    public EntityTag vehicle;
    public EntityTag entity;
    private double damage;
    public VehicleDamageEvent event;

    public VehicleDamagedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        List<String> split = CoreUtilities.split(lower, ' ');
        if (split.size() > 5) {
            return false;
        }
        if (split.size() > 3 && split.get(3).equals("by")) {
            return false;
        }
        String tid = CoreUtilities.getXthArg(0, lower);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return !tid.equals("entity") && (cmd.equals("damaged") || cmd.equals("damages") && !CoreUtilities.getXthArg(2, lower).equals("entity"));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String ent;
        String cmd = path.eventArgLowerAt(1);
        String veh = cmd.equals("damaged") ? path.eventArgLowerAt(0) : path.eventArgLowerAt(2);
        String string = ent = cmd.equals("damages") ? path.eventArgLowerAt(0) : "";
        if (!this.tryEntity(this.vehicle, veh)) {
            return false;
        }
        if (!ent.isEmpty() && this.entity != null && !this.tryEntity(this.entity, ent)) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "VehicleDamaged";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isDouble()) {
            this.damage = ((ElementTag)determinationObj).asDouble();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.entity != null) {
            return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
        }
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle.getDenizenObject();
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleDestroyed(VehicleDamageEvent event) {
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.entity = event.getAttacker() != null ? new EntityTag(event.getAttacker()) : null;
        this.damage = event.getDamage();
        this.event = event;
        this.fire((Event)event);
        event.setDamage(this.damage);
    }
}

