/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class PlayerCraftsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerCraftsItemScriptEvent instance;
    public CraftItemEvent event;
    public ItemTag result;
    public PlayerTag player;

    public PlayerCraftsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(0).equals("player") && path.eventArgLowerAt(1).equals("crafts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String eItem = path.eventArgLowerAt(2);
        if (!this.tryItem(this.result, eItem)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerCraftsItem";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.event.setCurrentItem(ItemTag.valueOf(determination, path.container).getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
        }
        if (name.equals("recipe")) {
            ListTag recipe = new ListTag();
            for (ItemStack itemStack : this.event.getInventory().getMatrix()) {
                if (itemStack != null) {
                    recipe.add(new ItemTag(itemStack).identify());
                    continue;
                }
                recipe.add(new ItemTag(Material.AIR).identify());
            }
            return recipe;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        Recipe eRecipe = event.getRecipe();
        if (eRecipe == null || eRecipe.getResult() == null) {
            return;
        }
        this.event = event;
        this.result = new ItemTag(eRecipe.getResult());
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.cancelled = false;
        this.fire((Event)event);
        if (this.cancelled) {
            event.setCancelled(true);
        }
    }
}

