/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Zombie;

public class EntityAge
implements Property {
    public static final String[] handledTags = new String[]{"age", "is_age_locked", "is_baby"};
    public static final String[] handledMechs = new String[]{"age_lock", "age"};
    EntityTag ageable;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntity() instanceof Ageable || ((EntityTag)entity).getBukkitEntity() instanceof Zombie;
    }

    public static EntityAge getFrom(ObjectTag entity) {
        if (!EntityAge.describes(entity)) {
            return null;
        }
        return new EntityAge((EntityTag)entity);
    }

    private EntityAge(EntityTag entity) {
        this.ageable = entity;
    }

    public boolean isBaby() {
        if (this.ageable.getBukkitEntity() instanceof Zombie) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby();
        }
        return !((Ageable)this.ageable.getBukkitEntity()).isAdult();
    }

    public void setBaby(boolean bool) {
        if (this.ageable.isCitizensNPC()) {
            NPC ageable_npc = this.ageable.getDenizenNPC().getCitizen();
            if (!ageable_npc.hasTrait(Age.class)) {
                ageable_npc.addTrait(Age.class);
            }
            ((Age)ageable_npc.getTrait(Age.class)).setAge(bool ? -24000 : 0);
        } else if (this.ageable.getBukkitEntity() instanceof Zombie) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(bool);
        } else if (bool) {
            ((Ageable)this.ageable.getBukkitEntity()).setBaby();
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAdult();
        }
    }

    public void setAge(int val) {
        if (this.ageable.isCitizensNPC()) {
            NPC ageable_npc = this.ageable.getDenizenNPC().getCitizen();
            ((Age)ageable_npc.getTrait(Age.class)).setAge(val);
        } else if (this.ageable.getBukkitEntity() instanceof Zombie) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(val >= 0);
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAge(val);
        }
    }

    public int getAge() {
        if (this.ageable.getBukkitEntity() instanceof Zombie) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby() ? -24000 : 0;
        }
        return ((Ageable)this.ageable.getBukkitEntity()).getAge();
    }

    public void setLock(boolean bool) {
        if (!(this.ageable.getBukkitEntity() instanceof Zombie)) {
            ((Ageable)this.ageable.getBukkitEntity()).setAgeLock(bool);
        }
    }

    public boolean getLock() {
        return this.ageable.getBukkitEntity() instanceof Zombie || ((Ageable)this.ageable.getBukkitEntity()).getAgeLock();
    }

    @Override
    public String getPropertyString() {
        return this.getAge() + (this.getLock() ? "|locked" : "");
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("age")) {
            return new ElementTag(this.getAge()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_age_locked")) {
            return new ElementTag(this.getLock()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_baby")) {
            return new ElementTag(this.isBaby()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("age_lock") && mechanism.requireBoolean()) {
            this.setLock(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("age")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.size() == 0) {
                Debug.echoError("Missing value for 'age' mechanism!");
                return;
            }
            if (((String)list.get(0)).equalsIgnoreCase("baby")) {
                this.setBaby(true);
            } else if (((String)list.get(0)).equalsIgnoreCase("adult")) {
                this.setBaby(false);
            } else if (new ElementTag((String)list.get(0)).isInt()) {
                this.setAge(new ElementTag((String)list.get(0)).asInt());
            }
            if (list.size() > 1 && ((String)list.get(1)).equalsIgnoreCase("locked")) {
                this.setLock(true);
            } else if (list.size() > 1 && ((String)list.get(1)).equalsIgnoreCase("unlocked")) {
                this.setLock(false);
            }
        }
    }
}

