/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;

public class InventoryHolder
implements Property {
    public static final String[] handledMechs = new String[]{"holder"};
    InventoryTag inventory;
    ObjectTag holder;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag;
    }

    public static InventoryHolder getFrom(ObjectTag inventory) {
        if (!InventoryHolder.describes(inventory)) {
            return null;
        }
        return new InventoryHolder((InventoryTag)inventory);
    }

    public InventoryHolder(InventoryTag inventory) {
        this.inventory = inventory;
        this.holder = this.getHolder();
    }

    public ObjectTag getHolder() {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        if (this.inventory.getIdType() != null && (this.inventory.getIdType().equals("player") || this.inventory.getIdType().equals("enderchest"))) {
            return PlayerTag.valueOf(this.inventory.getIdHolder());
        }
        if (this.inventory.getIdType() != null && this.inventory.getIdType().equalsIgnoreCase("script") && ScriptTag.matches(this.inventory.getIdHolder())) {
            return ScriptTag.valueOf(this.inventory.getIdHolder());
        }
        org.bukkit.inventory.InventoryHolder holder = this.inventory.getInventory().getHolder();
        if (holder != null) {
            if (holder instanceof NPCTag) {
                return (NPCTag)holder;
            }
            if (holder instanceof Player) {
                if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)((Player)holder))) {
                    return new NPCTag(CitizensAPI.getNPCRegistry().getNPC((Entity)((Player)holder)));
                }
                return new PlayerTag((Player)holder);
            }
            if (holder instanceof Entity) {
                return new EntityTag((Entity)holder);
            }
            if (holder instanceof DoubleChest) {
                return new LocationTag(((DoubleChest)holder).getLocation());
            }
            if (holder instanceof BlockState) {
                return new LocationTag(((BlockState)holder).getLocation());
            }
        } else {
            return new ElementTag(this.inventory.getIdHolder());
        }
        return null;
    }

    public void setHolder(PlayerTag player) {
        if (this.inventory.getIdType().equals("enderchest")) {
            this.inventory.setInventory(player.getBukkitEnderChest(), player);
        } else if (this.inventory.getIdType().equals("workbench")) {
            this.inventory.setInventory((Inventory)player.getBukkitWorkbench(), player);
        } else if (this.inventory.getIdType().equals("crafting")) {
            Inventory opened = player.getPlayerEntity().getOpenInventory().getTopInventory();
            if (opened instanceof CraftingInventory) {
                this.inventory.setInventory(opened, player);
            } else {
                this.inventory.setIdType("player");
                this.inventory.setInventory((Inventory)player.getBukkitInventory(), player);
            }
        } else {
            this.inventory.setInventory((Inventory)player.getBukkitInventory(), player);
        }
    }

    public void setHolder(NPCTag npc) {
        this.inventory.setInventory(npc.getInventory());
    }

    public void setHolder(EntityTag entity) {
        this.inventory.setInventory(entity.getBukkitInventory());
    }

    public void setHolder(LocationTag location) {
        if (!location.isChunkLoadedSafe()) {
            return;
        }
        this.inventory.setInventory(location.getBukkitInventory());
    }

    public void setHolder(ElementTag element) {
        if (element.matchesEnum((Enum[])InventoryType.values())) {
            this.inventory.setInventory(Bukkit.getServer().createInventory(null, InventoryType.valueOf((String)element.asString().toUpperCase())));
        }
    }

    @Override
    public String getPropertyString() {
        if (this.holder == null || this.inventory.getIdType().equals("generic") && this.inventory.getIdHolder().equals("CHEST")) {
            return null;
        }
        return this.holder.identify();
    }

    @Override
    public String getPropertyId() {
        return "holder";
    }

    public static void registerTags() {
        PropertyParser.registerTag("id_holder", (attribute, object) -> {
            ObjectTag holder = InventoryHolder.getFrom((ObjectTag)object).holder;
            if (holder == null) {
                return null;
            }
            return holder;
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("holder")) {
            if (mechanism.getValue().matchesEnum((Enum[])InventoryType.values())) {
                this.setHolder(mechanism.getValue());
            } else if (mechanism.getValue().matchesType(PlayerTag.class)) {
                this.setHolder(mechanism.valueAsType(PlayerTag.class));
            } else if (Depends.citizens != null && mechanism.getValue().matchesType(NPCTag.class)) {
                this.setHolder(mechanism.valueAsType(NPCTag.class));
            } else if (mechanism.getValue().matchesType(EntityTag.class)) {
                this.setHolder(mechanism.valueAsType(EntityTag.class));
            } else if (mechanism.getValue().matchesType(LocationTag.class)) {
                this.setHolder(mechanism.valueAsType(LocationTag.class));
            }
        }
    }
}

