/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFlags
implements Property {
    public static final String[] handledTags = new String[]{"flags"};
    public static final String[] handledMechs = new String[]{"flags"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getType() != Material.AIR;
    }

    public static ItemFlags getFrom(ObjectTag _item) {
        if (!ItemFlags.describes(_item)) {
            return null;
        }
        return new ItemFlags((ItemTag)_item);
    }

    private ItemFlags(ItemTag _item) {
        this.item = _item;
    }

    public ListTag flags() {
        ListTag output = new ListTag();
        ItemStack itemStack = this.item.getItemStack();
        if (itemStack.hasItemMeta()) {
            for (ItemFlag flag : itemStack.getItemMeta().getItemFlags()) {
                output.add(flag.name());
            }
        }
        return output;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("flags")) {
            return this.flags().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag flags = this.flags();
        if (flags.size() > 0) {
            return this.flags().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "flags";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("flags")) {
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            meta.removeItemFlags(ItemFlag.values());
            ListTag new_flags = mechanism.valueAsType(ListTag.class);
            for (String str : new_flags) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)str.toUpperCase())});
            }
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

