/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemSpawnerCount
implements Property {
    public static final String[] handledTags = new String[]{"spawner_count"};
    public static final String[] handledMechs = new String[]{"spawner_count"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemStack().getItemMeta()).hasBlockState() && ((BlockStateMeta)((ItemTag)item).getItemStack().getItemMeta()).getBlockState() instanceof CreatureSpawner;
    }

    public static ItemSpawnerCount getFrom(ObjectTag _item) {
        if (!ItemSpawnerCount.describes(_item)) {
            return null;
        }
        return new ItemSpawnerCount((ItemTag)_item);
    }

    private ItemSpawnerCount(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        BlockStateMeta meta;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("spawner_count") && (meta = (BlockStateMeta)this.item.getItemStack().getItemMeta()).hasBlockState()) {
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            return new ElementTag(state.getSpawnCount()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        BlockStateMeta meta = (BlockStateMeta)this.item.getItemStack().getItemMeta();
        if (meta.hasBlockState()) {
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            return String.valueOf(state.getSpawnCount());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "spawner_count";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        BlockStateMeta meta;
        if (mechanism.matches("spawner_count") && mechanism.requireInteger() && (meta = (BlockStateMeta)this.item.getItemStack().getItemMeta()).hasBlockState()) {
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            state.setSpawnCount(mechanism.getValue().asInt());
            meta.setBlockState((BlockState)state);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
    }
}

