/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class FormattedTextHelper {
    public static final String RESET = ChatColor.RESET.toString();

    public static String escape(String input) {
        return input.replace("&", "&amp").replace(";", "&sc").replace("[", "&lb").replace("]", "&rb").replace(String.valueOf('\u00a7'), "&ss");
    }

    public static String unescape(String input) {
        return input.replace("&sc", ";").replace("&lb", "[").replace("&rb", "]").replace("&ss", String.valueOf('\u00a7')).replace("&amp", "&");
    }

    public static String stringify(BaseComponent[] components) {
        StringBuilder builder = new StringBuilder(128 * components.length);
        for (BaseComponent component : components) {
            builder.append(FormattedTextHelper.stringify(component));
        }
        return builder.toString();
    }

    public static boolean boolNotNull(Boolean bool) {
        return bool != null && bool != false;
    }

    public static String stringify(BaseComponent component) {
        boolean hasClick;
        boolean hasHover;
        boolean hasInsertion;
        StringBuilder builder = new StringBuilder(128);
        ChatColor color = component.getColorRaw();
        if (color != null) {
            builder.append(color.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isBoldRaw())) {
            builder.append(ChatColor.BOLD.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isItalicRaw())) {
            builder.append(ChatColor.ITALIC.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isStrikethroughRaw())) {
            builder.append(ChatColor.STRIKETHROUGH.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isUnderlinedRaw())) {
            builder.append(ChatColor.UNDERLINE.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isObfuscatedRaw())) {
            builder.append(ChatColor.MAGIC.toString());
        }
        boolean bl = hasInsertion = component.getInsertion() != null;
        if (hasInsertion) {
            builder.append('\u00a7').append("[insertion=").append(FormattedTextHelper.escape(component.getInsertion())).append("]");
        }
        boolean bl2 = hasHover = component.getHoverEvent() != null;
        if (hasHover) {
            HoverEvent hover = component.getHoverEvent();
            builder.append('\u00a7').append("[hover=").append(hover.getAction().name()).append(";").append(FormattedTextHelper.escape(FormattedTextHelper.stringify(hover.getValue()))).append("]");
        }
        boolean bl3 = hasClick = component.getClickEvent() != null;
        if (hasClick) {
            ClickEvent click = component.getClickEvent();
            builder.append('\u00a7').append("[click=").append(click.getAction().name()).append(";").append(FormattedTextHelper.escape(click.getValue())).append("]");
        }
        if (component instanceof TranslatableComponent) {
            builder.append('\u00a7').append("[translate=").append(FormattedTextHelper.escape(((TranslatableComponent)component).getTranslate()));
            List with = ((TranslatableComponent)component).getWith();
            if (with != null) {
                for (BaseComponent withComponent : with) {
                    builder.append(";").append(FormattedTextHelper.escape(FormattedTextHelper.stringify(withComponent)));
                }
            }
            builder.append("]");
        } else if (component instanceof SelectorComponent) {
            builder.append('\u00a7').append("[selector=").append(FormattedTextHelper.escape(((SelectorComponent)component).getSelector())).append("]");
        } else if (component instanceof KeybindComponent) {
            builder.append('\u00a7').append("[keybind=").append(FormattedTextHelper.escape(((KeybindComponent)component).getKeybind())).append("]");
        } else if (component instanceof ScoreComponent) {
            builder.append('\u00a7').append("[score=").append(FormattedTextHelper.escape(((ScoreComponent)component).getName())).append(";").append(FormattedTextHelper.escape(((ScoreComponent)component).getObjective())).append(";").append(FormattedTextHelper.escape(((ScoreComponent)component).getValue())).append("]");
        } else if (component instanceof TextComponent) {
            builder.append(((TextComponent)component).getText());
        }
        List after = component.getExtra();
        if (after != null) {
            for (BaseComponent afterComponent : after) {
                builder.append(FormattedTextHelper.stringify(afterComponent));
            }
        }
        if (hasClick) {
            builder.append("\u00a7[/click]");
        }
        if (hasHover) {
            builder.append("\u00a7[/hover]");
        }
        if (hasInsertion) {
            builder.append("\u00a7[/insertion]");
        }
        builder.append(RESET);
        String output = builder.toString();
        while (output.contains(RESET + RESET)) {
            output = output.replace(RESET + RESET, RESET);
        }
        return output;
    }

    public static TextComponent copyFormatToNewText(TextComponent last) {
        TextComponent toRet = new TextComponent();
        toRet.setObfuscated(last.isObfuscatedRaw());
        toRet.setBold(last.isBoldRaw());
        toRet.setStrikethrough(last.isStrikethroughRaw());
        toRet.setUnderlined(last.isUnderlinedRaw());
        toRet.setItalic(last.isItalicRaw());
        toRet.setColor(last.getColorRaw());
        return toRet;
    }

    public static BaseComponent[] parse(String str) {
        char[] chars = str.toCharArray();
        ArrayList<TextComponent> outputList = new ArrayList<TextComponent>();
        int started = 0;
        TextComponent nextText = new TextComponent();
        for (int i = 0; i < chars.length; ++i) {
            String subStr;
            if (chars[i] == '\u00a7' && i + 1 < chars.length) {
                char code = chars[i + 1];
                if (code == '[') {
                    int endBracket = str.indexOf(93, i + 2);
                    if (endBracket == -1) continue;
                    String innards = str.substring(i + 2, endBracket);
                    List<String> innardParts = CoreUtilities.split(innards, ';');
                    List<String> innardBase = CoreUtilities.split(innardParts.get(0), '=', 2);
                    innardParts.remove(0);
                    String innardType = CoreUtilities.toLowerCase(innardBase.get(0));
                    if (innardBase.size() == 2) {
                        nextText.setText(nextText.getText() + str.substring(started, i));
                        outputList.add(nextText);
                        TextComponent lastText = nextText;
                        nextText = FormattedTextHelper.copyFormatToNewText(lastText);
                        nextText.setText("");
                        if (innardType.equals("score") && innardParts.size() == 2) {
                            ScoreComponent component = new ScoreComponent(FormattedTextHelper.unescape(innardBase.get(1)), FormattedTextHelper.unescape(innardParts.get(0)), FormattedTextHelper.unescape(innardParts.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("keybind")) {
                            KeybindComponent component = new KeybindComponent();
                            component.setKeybind(FormattedTextHelper.unescape(innardBase.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("selector")) {
                            SelectorComponent component = new SelectorComponent(FormattedTextHelper.unescape(innardBase.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("translate")) {
                            TranslatableComponent component = new TranslatableComponent();
                            component.setTranslate(FormattedTextHelper.unescape(innardBase.get(1)));
                            for (String extra : innardParts) {
                                for (BaseComponent subComponent : FormattedTextHelper.parse(FormattedTextHelper.unescape(extra))) {
                                    component.addWith(subComponent);
                                }
                            }
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("click") && innardParts.size() == 1) {
                            int endIndex = str.indexOf("\u00a7[/click]", i);
                            int backupEndIndex = str.indexOf("\u00a7[click=", i + 5);
                            if (backupEndIndex > 0 && backupEndIndex < endIndex) {
                                endIndex = backupEndIndex;
                            }
                            if (endIndex == -1) continue;
                            TextComponent clickableText = new TextComponent();
                            clickableText.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf((String)innardBase.get(1).toUpperCase()), FormattedTextHelper.unescape(innardParts.get(0))));
                            for (BaseComponent subComponent : FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex))) {
                                clickableText.addExtra(subComponent);
                            }
                            lastText.addExtra((BaseComponent)clickableText);
                            endBracket = endIndex + "&[/click".length();
                        } else if (innardType.equals("hover")) {
                            BaseComponent[] hoverValue;
                            int endIndex = str.indexOf("\u00a7[/hover]", i);
                            int backupEndIndex = str.indexOf("\u00a7[hover=", i + 5);
                            if (backupEndIndex > 0 && backupEndIndex < endIndex) {
                                endIndex = backupEndIndex;
                            }
                            if (endIndex == -1) continue;
                            TextComponent hoverableText = new TextComponent();
                            HoverEvent.Action action = HoverEvent.Action.valueOf((String)innardBase.get(1).toUpperCase());
                            if (action == HoverEvent.Action.SHOW_ITEM) {
                                ItemTag item = ItemTag.valueOf(FormattedTextHelper.unescape(innardParts.get(0)));
                                if (item == null) continue;
                                hoverValue = new BaseComponent[]{new TextComponent(NMSHandler.getItemHelper().getRawHoverText(item.getItemStack()))};
                            } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                                EntityTag entity = EntityTag.valueOf(FormattedTextHelper.unescape(innardParts.get(0)));
                                if (entity == null) continue;
                                hoverValue = new BaseComponent[]{new TextComponent(NMSHandler.getEntityHelper().getRawHoverText(entity.getBukkitEntity()))};
                            } else {
                                hoverValue = FormattedTextHelper.parse(FormattedTextHelper.unescape(innardParts.get(0)));
                            }
                            hoverableText.setHoverEvent(new HoverEvent(action, hoverValue));
                            for (BaseComponent subComponent : FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex))) {
                                hoverableText.addExtra(subComponent);
                            }
                            lastText.addExtra((BaseComponent)hoverableText);
                            endBracket = endIndex + "&[/hover".length();
                        } else if (innardType.equals("insertion")) {
                            int endIndex = str.indexOf("\u00a7[/insertion]", i);
                            int backupEndIndex = str.indexOf("\u00a7[insertion=", i + 5);
                            if (backupEndIndex > 0 && backupEndIndex < endIndex) {
                                endIndex = backupEndIndex;
                            }
                            if (endIndex == -1) continue;
                            TextComponent insertableText = new TextComponent();
                            insertableText.setInsertion(FormattedTextHelper.unescape(innardBase.get(1)));
                            for (BaseComponent subComponent : FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex))) {
                                insertableText.addExtra(subComponent);
                            }
                            lastText.addExtra((BaseComponent)insertableText);
                            endBracket = endIndex + "&[/insertion".length();
                        } else if (innardType.equals("reset")) {
                            char subCode = innardBase.get(1).charAt(0);
                            if (subCode == 'k' || subCode == 'K') {
                                nextText.setObfuscated(Boolean.valueOf(false));
                            } else if (subCode == 'l' || subCode == 'L') {
                                nextText.setBold(Boolean.valueOf(false));
                            } else if (subCode == 'm' || subCode == 'M') {
                                nextText.setStrikethrough(Boolean.valueOf(false));
                            } else if (subCode == 'n' || subCode == 'N') {
                                nextText.setUnderlined(Boolean.valueOf(false));
                            } else if (subCode == 'o' || subCode == 'O') {
                                nextText.setItalic(Boolean.valueOf(false));
                            }
                        } else if (innardType.equals("color")) {
                            String colorChar = innardBase.get(1);
                            nextText.setColor(ChatColor.getByChar((char)colorChar.charAt(0)));
                        }
                    }
                    i = endBracket;
                    started = endBracket + 1;
                    continue;
                }
                if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f' || code >= 'A' && code <= 'F') {
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    outputList.add(nextText);
                    nextText = new TextComponent();
                    nextText.setColor(ChatColor.getByChar((char)code));
                } else if (code >= 'k' && code <= 'o' || code >= 'K' && code <= 'O') {
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    outputList.add(nextText);
                    nextText = FormattedTextHelper.copyFormatToNewText(nextText);
                    if (code == 'k' || code == 'K') {
                        nextText.setObfuscated(Boolean.valueOf(true));
                    } else if (code == 'l' || code == 'L') {
                        nextText.setBold(Boolean.valueOf(true));
                    } else if (code == 'm' || code == 'M') {
                        nextText.setStrikethrough(Boolean.valueOf(true));
                    } else if (code == 'n' || code == 'N') {
                        nextText.setUnderlined(Boolean.valueOf(true));
                    } else if (code == 'o' || code == 'O') {
                        nextText.setItalic(Boolean.valueOf(true));
                    }
                } else {
                    if (code != 'r' && code != 'R') continue;
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    outputList.add(nextText);
                    nextText = new TextComponent();
                }
                started = ++i + 1;
                continue;
            }
            if (i + "https://a.".length() >= chars.length || chars[i] != 'h' || chars[i + 1] != 't' || chars[i + 2] != 't' || chars[i + 3] != 'p' || !(subStr = str.substring(i, i + "https://a.".length())).startsWith("https://") && !subStr.startsWith("http://")) continue;
            int nextSpace = str.indexOf(32, i);
            if (nextSpace == -1) {
                nextSpace = str.length();
            }
            String url = str.substring(i, nextSpace);
            nextText.setText(nextText.getText() + str.substring(started, i));
            outputList.add(nextText);
            TextComponent lastText = nextText;
            nextText = new TextComponent(lastText);
            nextText.setText("");
            TextComponent clickableText = new TextComponent(url);
            clickableText.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            lastText.addExtra((BaseComponent)clickableText);
            i = nextSpace;
            started = nextSpace;
        }
        nextText.setText(nextText.getText() + str.substring(started));
        if (!nextText.getText().isEmpty()) {
            outputList.add(nextText);
        }
        return outputList.toArray(new BaseComponent[0]);
    }
}

