/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.json.JSONObject;

public class ScriptTag
implements ObjectTag,
Adjustable {
    private ScriptContainer container;
    private String prefix = "Container";
    private boolean valid = false;
    private String name = null;
    public static ObjectTagProcessor<ScriptTag> tagProcessor = new ObjectTagProcessor();

    public static ScriptTag valueOf(String string) {
        return ScriptTag.valueOf(string, null);
    }

    @Fetchable(value="s")
    public static ScriptTag valueOf(String string, TagContext context) {
        ScriptTag script;
        if (string.startsWith("s@")) {
            string = string.substring(2);
        }
        if ((script = new ScriptTag(string)).isValid()) {
            return script;
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("s@")) {
            return true;
        }
        ScriptTag script = new ScriptTag(string);
        return script.isValid();
    }

    public ScriptTag(String scriptName) {
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public ScriptTag(ScriptContainer container) {
        this.container = container;
        this.name = container.getName().toUpperCase();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    @Override
    public String getObjectType() {
        return "Container";
    }

    @Override
    public String identify() {
        return "s@" + this.name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "s@" + this.name + "<GR> (" + this.getType() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    public static void registerTags() {
        ScriptTag.registerTag("container_type", (attribute, object) -> new ElementTag(object.container.getContainerType()), new String[0]);
        ScriptTag.registerTag("name", (attribute, object) -> new ElementTag(object.name), new String[0]);
        ScriptTag.registerTag("relative_filename", (attribute, object) -> new ElementTag(object.container.getRelativeFileName()), new String[0]);
        ScriptTag.registerTag("filename", (attribute, object) -> new ElementTag(object.container.getFileName().replace("\\", "/")), new String[0]);
        ScriptTag.registerTag("original_name", (attribute, object) -> new ElementTag(object.container.getOriginalName()), new String[0]);
        ScriptTag.registerTag("constant", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ScriptTag.constant[...] must have a value.");
                return null;
            }
            YamlConfiguration section = object.getContainer().getConfigurationSection("default constants");
            if (section == null) {
                return null;
            }
            Object obj = section.get(attribute.getContext(1).toUpperCase());
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                ListTag list = new ListTag();
                for (Object each : (List)obj) {
                    if (each == null) {
                        each = "null";
                    }
                    list.add(TagManager.tag(each.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
                }
                return list;
            }
            return new ElementTag(TagManager.tag(obj.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
        }, new String[0]);
        ScriptTag.registerTag("yaml_key", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ScriptTag.constant[...] must have a value.");
                return null;
            }
            ScriptTag scr = object;
            ScriptContainer container = scr.getContainer();
            if (container == null) {
                Debug.echoError("Missing script container?!");
                return null;
            }
            YamlConfiguration section = container.getConfigurationSection("");
            if (section == null) {
                Debug.echoError("Missing YAML section?!");
                return null;
            }
            Object obj = section.get(attribute.getContext(1).toUpperCase());
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                ListTag list = new ListTag();
                for (Object each : (List)obj) {
                    if (each == null) {
                        each = "null";
                    }
                    list.add(ScriptBuilder.stripLinePrefix(each.toString()));
                }
                return list;
            }
            return new ElementTag(obj.toString());
        }, new String[0]);
        ScriptTag.registerTag("list_keys", (attribute, object) -> {
            YamlConfiguration conf = object.getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
            if (conf == null) {
                return null;
            }
            return new ListTag(conf.getKeys(false));
        }, new String[0]);
        ScriptTag.registerTag("list_deep_keys", (attribute, object) -> {
            YamlConfiguration conf = object.getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
            if (conf == null) {
                return null;
            }
            return new ListTag(conf.getKeys(true));
        }, new String[0]);
        ScriptTag.registerTag("to_json", (attribute, object) -> {
            JSONObject jsobj = new JSONObject(YamlConfiguration.reverse(object.container.getContents().getMap(), true));
            jsobj.remove("TYPE");
            return new ElementTag(jsobj.toString());
        }, new String[0]);
        ScriptTag.registerTag("to_text", (attribute, object) -> {
            YamlConfiguration config = new YamlConfiguration();
            config.addAll(object.getContainer().getContents().getMap());
            config.set("type", null);
            return new ElementTag(config.saveToString(true));
        }, new String[0]);
        ScriptTag.registerTag("type", (attribute, object) -> new ElementTag("Script"), new String[0]);
        ScriptTag.registerTag("list_queues", (attribute, object) -> {
            ScriptTag script = object;
            ListTag queues = new ListTag();
            for (ScriptQueue queue : ScriptQueue.getQueues()) {
                if (queue.script == null || !queue.script.getName().equals(script.getName())) continue;
                queues.addObject(new QueueTag(queue));
            }
            return queues;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ScriptTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a script!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

