/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.core;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;

public class ListPingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ListPingScriptEvent instance;
    public ServerListPingEvent event;

    public ListPingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("server list ping");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ServerListPing";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            String[] values = determination.split("[\\|" + ListTag.internal_escape + "]", 2);
            if (new ElementTag(values[0]).isInt()) {
                this.event.setMaxPlayers(new ElementTag(values[0]).asInt());
                if (values.length == 1) {
                    return true;
                }
            }
            if (values.length == 2) {
                this.event.setMotd(values[1]);
            } else {
                this.event.setMotd(values[0]);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("motd")) {
            return new ElementTag(this.event.getMotd());
        }
        if (name.equals("max_players")) {
            return new ElementTag(this.event.getMaxPlayers());
        }
        if (name.equals("num_players")) {
            return new ElementTag(this.event.getNumPlayers());
        }
        if (name.equals("address")) {
            return new ElementTag(this.event.getAddress().toString());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onListPing(ServerListPingEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

