/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class EntityExplodesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityExplodesScriptEvent instance;
    public EntityTag entity;
    public ListTag blocks;
    public LocationTag location;
    public float strength;
    private Boolean blockSet;
    public EntityExplodeEvent event;

    public EntityExplodesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("explodes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityExplodes";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ArgumentHelper.matchesDouble(determination)) {
            this.strength = ArgumentHelper.getFloatFrom(determination);
            return true;
        }
        if (ListTag.matches(determination)) {
            this.blocks = new ListTag();
            this.blockSet = true;
            for (String loc : ListTag.valueOf(determination)) {
                LocationTag location = LocationTag.valueOf(loc);
                if (location == null) {
                    Debug.echoError("Invalid location '" + loc + "' check [" + this.getName() + "]: '  for " + path.container.getName());
                    continue;
                }
                this.blocks.add(location.identifySimple());
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        if (name.equals("strength")) {
            return new ElementTag(this.strength);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getLocation());
        this.strength = event.getYield();
        this.blocks = new ListTag();
        this.blockSet = false;
        for (Block block : event.blockList()) {
            this.blocks.add(new LocationTag(block.getLocation()).identify());
        }
        this.event = event;
        this.fire((Event)event);
        if (this.blockSet.booleanValue()) {
            event.blockList().clear();
            if (this.blocks.size() > 0) {
                event.blockList().clear();
                for (String loc : this.blocks) {
                    LocationTag location = LocationTag.valueOf(loc);
                    event.blockList().add(location.getWorld().getBlockAt((Location)location));
                }
            }
        }
        event.setYield(this.strength);
    }
}

