/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityPotionEffects;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPotionEffectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityPotionEffectScriptEvent instance;
    public EntityTag entity;
    public EntityPotionEffectEvent event;

    public EntityPotionEffectScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains(" potion effects ");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        String change = path.eventArgAt(3);
        if (!change.equals("modified") && !this.runGenericCheck(change, CoreUtilities.toLowerCase(this.event.getAction().name()))) {
            return false;
        }
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "cause", CoreUtilities.toLowerCase(this.event.getCause().name()))) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "effect", CoreUtilities.toLowerCase(this.event.getModifiedType().getName()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PotionEffectsModified";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("override:")) {
            this.event.setOverride(lower.substring("override".length()).equals("true"));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("cause")) {
            return new ElementTag(this.event.getCause().name());
        }
        if (name.equals("action")) {
            return new ElementTag(this.event.getAction().name());
        }
        if (name.equals("effect_type")) {
            return new ElementTag(this.event.getModifiedType().getName());
        }
        if (name.equals("override")) {
            return new ElementTag(this.event.isOverride());
        }
        if (name.equals("new_effect") && this.event.getNewEffect() != null) {
            return new ElementTag(EntityPotionEffects.stringify(this.event.getNewEffect()));
        }
        if (name.equals("old_effect") && this.event.getOldEffect() != null) {
            return new ElementTag(EntityPotionEffects.stringify(this.event.getOldEffect()));
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

