/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Wolf;

public class EntityAngry
implements Property {
    public static final String[] handledTags = new String[]{"angry"};
    public static final String[] handledMechs = new String[]{"angry"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntityType() == EntityType.WOLF || ((EntityTag)entity).getBukkitEntityType() == EntityType.PIG_ZOMBIE);
    }

    public static EntityAngry getFrom(ObjectTag entity) {
        if (!EntityAngry.describes(entity)) {
            return null;
        }
        return new EntityAngry((EntityTag)entity);
    }

    private EntityAngry(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        if (this.entity.getBukkitEntityType() == EntityType.WOLF) {
            if (!((Wolf)this.entity.getLivingEntity()).isAngry()) {
                return null;
            }
            return "true";
        }
        if (this.entity.getBukkitEntityType() == EntityType.PIG_ZOMBIE) {
            if (!((PigZombie)this.entity.getLivingEntity()).isAngry()) {
                return null;
            }
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "angry";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("angry")) {
            if (this.entity.getBukkitEntityType() == EntityType.WOLF) {
                return new ElementTag(((Wolf)this.entity.getBukkitEntity()).isAngry()).getObjectAttribute(attribute.fulfill(1));
            }
            if (this.entity.getBukkitEntityType() == EntityType.PIG_ZOMBIE) {
                return new ElementTag(((PigZombie)this.entity.getBukkitEntity()).isAngry()).getObjectAttribute(attribute.fulfill(1));
            }
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("angry") && mechanism.requireBoolean()) {
            if (this.entity.getBukkitEntityType() == EntityType.WOLF) {
                ((Wolf)this.entity.getBukkitEntity()).setAngry(mechanism.getValue().asBoolean());
            } else if (this.entity.getBukkitEntityType() == EntityType.PIG_ZOMBIE) {
                ((PigZombie)this.entity.getBukkitEntity()).setAngry(mechanism.getValue().asBoolean());
            }
        }
    }
}

