/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Cake;

public class MaterialLevel
implements Property {
    public static final String[] handledTags = new String[]{"maximum_level", "level"};
    public static final String[] handledMechs = new String[]{"level"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData().data instanceof Levelled || ((MaterialTag)material).getModernData().data instanceof Cake);
    }

    public static MaterialLevel getFrom(ObjectTag _material) {
        if (!MaterialLevel.describes(_material)) {
            return null;
        }
        return new MaterialLevel((MaterialTag)_material);
    }

    private MaterialLevel(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("maximum_level")) {
            return new ElementTag(this.getMax()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("level")) {
            return new ElementTag(this.getCurrent()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public boolean isCake() {
        return this.material.getModernData().data instanceof Cake;
    }

    public Levelled getLevelled() {
        return (Levelled)this.material.getModernData().data;
    }

    public Cake getCake() {
        return (Cake)this.material.getModernData().data;
    }

    public int getCurrent() {
        if (this.isCake()) {
            return this.getCake().getBites();
        }
        return this.getLevelled().getLevel();
    }

    public int getMax() {
        if (this.isCake()) {
            return this.getCake().getMaximumBites();
        }
        return this.getLevelled().getMaximumLevel();
    }

    public void setCurrent(int level) {
        if (this.isCake()) {
            this.getCake().setBites(level);
            return;
        }
        this.getLevelled().setLevel(level);
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "level";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            int level = mechanism.getValue().asInt();
            if (level < 0 || level > this.getMax()) {
                Debug.echoError("Level value '" + level + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.setCurrent(level);
        }
    }
}

