/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Switch;

public class MaterialSwitchFace
implements Property {
    public static final String[] handledTags = new String[]{"switch_face"};
    public static final String[] handledMechs = new String[]{"switch_face"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof Switch;
    }

    public static MaterialSwitchFace getFrom(ObjectTag _material) {
        if (!MaterialSwitchFace.describes(_material)) {
            return null;
        }
        return new MaterialSwitchFace((MaterialTag)_material);
    }

    private MaterialSwitchFace(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("switch_face")) {
            return new ElementTag(this.getSwitch().getFace().name()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Switch getSwitch() {
        return (Switch)this.material.getModernData().data;
    }

    @Override
    public String getPropertyString() {
        return this.getSwitch().getFace().name();
    }

    public BlockFace getAttachedTo() {
        switch (this.getSwitch().getFace()) {
            case WALL: {
                return this.getSwitch().getFacing().getOppositeFace();
            }
            case FLOOR: {
                return BlockFace.DOWN;
            }
            case CEILING: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    @Override
    public String getPropertyId() {
        return "switch_face";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("switch_face") && mechanism.requireEnum(false, (Enum<?>[])Switch.Face.values())) {
            this.getSwitch().setFace(Switch.Face.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
    }
}

