/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.List;

public class TitleCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("title")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("subtitle")) {
                scriptEntry.addObject("subtitle", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("fade_in") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("fade_in", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesPrefix("stay") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("stay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesPrefix("fade_out") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("fade_out", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesPrefix("targets", "target") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("title") && !scriptEntry.hasObject("subtitle")) {
            throw new InvalidArgumentsException("Must have a title or subtitle!");
        }
        scriptEntry.defaultObject("fade_in", new DurationTag(1)).defaultObject("stay", new DurationTag(3)).defaultObject("fade_out", new DurationTag(1)).defaultObject("targets", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag title = scriptEntry.getElement("title");
        ElementTag subtitle = scriptEntry.getElement("subtitle");
        DurationTag fade_in = (DurationTag)scriptEntry.getObjectTag("fade_in");
        DurationTag stay = (DurationTag)scriptEntry.getObjectTag("stay");
        DurationTag fade_out = (DurationTag)scriptEntry.getObjectTag("fade_out");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (title != null ? title.debug() : "") + (subtitle != null ? subtitle.debug() : "") + fade_in.debug() + stay.debug() + fade_out.debug() + ArgumentHelper.debugObj("targets", targets));
        }
        for (PlayerTag player : targets) {
            if (!player.isValid() || !player.isOnline()) continue;
            NMSHandler.getPacketHelper().showTitle(player.getPlayerEntity(), title != null ? title.asString() : "", subtitle != null ? subtitle.asString() : "", fade_in.getTicksAsInt(), stay.getTicksAsInt(), fade_out.getTicksAsInt());
        }
    }
}

