/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class RunCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("i", "id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("d", "def", "define", "c", "context")) {
                scriptEntry.addObject("definitions", arg.asElement());
                continue;
            }
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new ElementTag("true"));
                scriptEntry.addObject("script", scriptEntry.getScript());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("speed", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                ScriptTag script;
                int dotIndex;
                String path = arg.asElement().asString();
                if (!scriptEntry.hasObject("script") && (dotIndex = path.indexOf(46)) > 0 && (script = new ScriptTag(path.substring(0, dotIndex))).isValid()) {
                    scriptEntry.addObject("script", script);
                    path = path.substring(dotIndex + 1);
                }
                scriptEntry.addObject("path", new ElementTag(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!(scriptEntry.hasObject("script") || scriptEntry.hasObject("local") && scriptEntry.getScript() != null)) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptQueue queue;
        String id;
        List<ScriptEntry> entries;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getObjectTag("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getObjectTag("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : "") + (scriptEntry.hasObject("delay") ? scriptEntry.getObjectTag("delay").debug() : "") + (scriptEntry.hasObject("id") ? scriptEntry.getObjectTag("id").debug() : "") + (scriptEntry.hasObject("definitions") ? scriptEntry.getObjectTag("definitions").debug() : "") + (scriptEntry.hasObject("speed") ? scriptEntry.getObjectTag("speed").debug() : ""));
        }
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (scriptEntry.hasObject("local")) {
            entries = scriptEntry.getScript().getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString());
            script = scriptEntry.getScript();
        } else {
            entries = scriptEntry.hasObject("path") && scriptEntry.getObject("path") != null ? script.getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
        }
        if (entries == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid path or script name)!");
            return;
        }
        String string = id = scriptEntry.hasObject("id") ? "FORCE:" + scriptEntry.getElement("id").asString() : script.getContainer().getName();
        if (scriptEntry.hasObject("instant")) {
            queue = new InstantQueue(id).addEntries(entries);
        } else {
            DurationTag speed = scriptEntry.hasObject("speed") ? (DurationTag)scriptEntry.getObjectTag("speed") : (script != null && script.getContainer().contains("SPEED") ? DurationTag.valueOf(script.getContainer().getString("SPEED", "0")) : DurationTag.valueOf(DenizenCore.getImplementation().scriptQueueSpeed()));
            queue = speed.getTicks() > 0L ? new TimedQueue(id).setSpeed(speed.getTicks()).addEntries(entries) : new InstantQueue(id).addEntries(entries);
        }
        if (scriptEntry.hasObject("delay")) {
            queue.delayUntil(DenizenCore.serverTimeMillis + ((DurationTag)scriptEntry.getObject("delay")).getMillis());
        }
        if (scriptEntry.hasObject("definitions")) {
            int x = 1;
            ElementTag raw_defintions = scriptEntry.getElement("definitions");
            ListTag definitions = ListTag.valueOf(raw_defintions.asString());
            String[] definition_names = null;
            try {
                String str;
                if (script != null && script.getContainer() != null && (str = script.getContainer().getString("definitions")) != null) {
                    definition_names = str.split("\\|");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String definition : definitions) {
                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                queue.addDefinition(name, definition);
                Debug.echoDebug((Debuggable)scriptEntry, "Adding definition '" + name + "' as " + definition);
                ++x;
            }
            queue.addDefinition("raw_context", raw_defintions.asString());
        }
        if (scriptEntry.shouldWaitFor()) {
            final ScriptEntry se = scriptEntry;
            queue.callBack(new Runnable(){

                @Override
                public void run() {
                    se.setFinished(true);
                }
            });
        }
        scriptEntry.addObject("created_queue", new QueueTag(queue));
        queue.start();
    }
}

