/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.containers.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskScriptContainer
extends ScriptContainer {
    DurationTag speed = null;

    public TaskScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public DurationTag getSpeed() {
        String tmp;
        if (this.speed != null) {
            return this.speed;
        }
        this.speed = this.contains("speed") ? (CoreUtilities.toLowerCase(tmp = this.getString("speed", "0t")).equals("instant") ? DurationTag.valueOf("0t") : DurationTag.valueOf(tmp)) : DurationTag.valueOf(DenizenCore.getImplementation().scriptQueueSpeed());
        return this.speed;
    }

    public TaskScriptContainer setSpeed(DurationTag speed) {
        this.speed = speed;
        return this;
    }

    public ScriptQueue runTaskScript(ScriptEntryData data, Map<String, String> context) {
        return this.runTaskScript(this.getName(), data, context);
    }

    public ScriptQueue runTaskScript(String queueId, ScriptEntryData data, Map<String, String> context) {
        ScriptQueue queue = this.getSpeed().getSeconds() == 0.0 ? new InstantQueue(queueId) : new TimedQueue(queueId).setSpeed(this.getSpeed().getTicks());
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        queue.start();
        return queue;
    }

    public Map<String, Integer> getContextMap() {
        if (this.contains("CONTEXT")) {
            HashMap<String, Integer> context = new HashMap<String, Integer>();
            int x = 1;
            for (String name : this.getString("CONTEXT").split("\\|")) {
                context.put(name.toUpperCase(), x);
                ++x;
            }
            return context;
        }
        return Collections.emptyMap();
    }

    public ScriptQueue runTaskScriptWithDelay(String queueId, ScriptEntryData data, Map<String, String> context, DurationTag delay) {
        ScriptQueue queue = this.getSpeed().getSeconds() == 0.0 ? new InstantQueue(queueId) : new TimedQueue(queueId).setSpeed(this.getSpeed().getTicks());
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        queue.delayUntil(DenizenCore.serverTimeMillis + (long)(delay.getSeconds() * 1000.0));
        queue.start();
        return queue;
    }

    public ScriptQueue injectTaskScript(String queueId, ScriptEntryData data, Map<String, String> context) {
        ScriptQueue queue = ScriptQueue.getExistingQueue(queueId);
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.injectEntries(listOfEntries, 0);
        queue.start();
        return queue;
    }
}

