/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class EntityChangesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityChangesBlockScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public MaterialTag old_material;
    public MaterialTag new_material;
    public EntityChangeBlockEvent event;

    public EntityChangesBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "changes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entName = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, entName)) {
            return false;
        }
        if (!this.tryMaterial(this.old_material, path.eventArgLowerAt(2))) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into")) {
            String mat2 = path.eventArgLowerAt(4);
            if (mat2.isEmpty()) {
                Debug.echoError("Invalid event material [" + this.getName() + "]: '" + path.event + "' for " + path.container.getName());
                return false;
            }
            if (!this.tryMaterial(this.new_material, mat2)) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityChangesBlock";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return this.new_material;
        }
        if (name.equals("old_material")) {
            return this.old_material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityChangesBlock(EntityChangeBlockEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_material = new MaterialTag(this.location.getBlock());
        this.new_material = new MaterialTag(event.getTo());
        this.event = event;
        this.fire((Event)event);
    }
}

