/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityExplosionPrimesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityExplosionPrimesScriptEvent instance;
    public EntityTag entity;
    public Float radius;
    public Boolean fire;
    public ExplosionPrimeEvent event;

    public EntityExplosionPrimesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains("explosion primes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityExplosionPrimes";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ArgumentHelper.matchesDouble(determination)) {
            this.radius = Float.valueOf(Float.parseFloat(determination));
            return true;
        }
        if (Argument.valueOf(determination).matchesPrimitive(ArgumentHelper.PrimitiveType.Boolean)) {
            this.fire = determination.equalsIgnoreCase("true");
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("radius")) {
            return new ElementTag(this.radius.floatValue());
        }
        if (name.equals("fire")) {
            return new ElementTag(this.fire);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityExplosionPrimes(ExplosionPrimeEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.radius = Float.valueOf(event.getRadius());
        this.fire = event.getFire();
        this.event = event;
        this.fire((Event)event);
        event.setFire(this.fire.booleanValue());
        event.setRadius(this.radius.floatValue());
    }
}

