/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public abstract class BiomeNMS {
    private final String name;

    public BiomeNMS(Biome biome) {
        this.name = biome.name();
    }

    public DownfallType getDownfallType() {
        if (this.getDoesSnow()) {
            return DownfallType.SNOW;
        }
        if (this.getDoesRain()) {
            return DownfallType.RAIN;
        }
        return DownfallType.NONE;
    }

    public String getName() {
        return this.name;
    }

    public abstract float getHumidity();

    public abstract float getTemperature();

    public List<EntityType> getAllEntities() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.addAll(this.getAmbientEntities());
        entityTypes.addAll(this.getCreatureEntities());
        entityTypes.addAll(this.getMonsterEntities());
        entityTypes.addAll(this.getWaterEntities());
        return entityTypes;
    }

    public abstract List<EntityType> getAmbientEntities();

    public abstract List<EntityType> getCreatureEntities();

    public abstract List<EntityType> getMonsterEntities();

    public abstract List<EntityType> getWaterEntities();

    public abstract void setHumidity(float var1);

    public abstract void setTemperature(float var1);

    public abstract void changeBlockBiome(Location var1);

    protected abstract boolean getDoesRain();

    protected abstract boolean getDoesSnow();

    public static enum DownfallType {
        RAIN,
        SNOW,
        NONE;

    }
}

