/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.server.v1_14_R1.FurnaceRecipe;
import net.minecraft.server.v1_14_R1.GameProfileSerializer;
import net.minecraft.server.v1_14_R1.IRecipe;
import net.minecraft.server.v1_14_R1.MinecraftKey;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NonNullList;
import net.minecraft.server.v1_14_R1.RecipeBlasting;
import net.minecraft.server.v1_14_R1.RecipeCampfire;
import net.minecraft.server.v1_14_R1.RecipeItemStack;
import net.minecraft.server.v1_14_R1.RecipeSmoking;
import net.minecraft.server.v1_14_R1.RecipeStonecutting;
import net.minecraft.server.v1_14_R1.ShapelessRecipes;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemHelperImpl
extends ItemHelper {
    @Override
    public Recipe getRecipeById(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            IRecipe recipe = (IRecipe)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe.toBukkitRecipe();
        }
        return null;
    }

    @Override
    public void removeRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            recipeMap.remove((Object)nmsKey);
        }
    }

    @Override
    public void clearDenizenRecipes() {
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            for (MinecraftKey key : new ArrayList(recipeMap.keySet())) {
                if (!key.getNamespace().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
            }
        }
    }

    @Override
    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c, ItemStack item, boolean exact) {
        if (exact) {
            recipe.setIngredient(c, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            recipe.setIngredient(c, item.getType());
        }
    }

    @Override
    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack ingredient, float exp, int time, String type, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.asList(new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((ItemStack)ingredient))).stream());
        itemRecipe.exact = exact;
        Object recipe = type.equalsIgnoreCase("smoker") ? new RecipeSmoking(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new RecipeBlasting(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new RecipeCampfire(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new FurnaceRecipe(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack ingredient, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.asList(new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((ItemStack)ingredient))).stream());
        itemRecipe.exact = exact;
        RecipeStonecutting recipe = new RecipeStonecutting(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public void registerShapelessRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredients, boolean[] exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        for (int i = 0; i < ingredients.length; ++i) {
            RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.asList(new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((ItemStack)ingredients[i]))).stream());
            itemRecipe.exact = exact[i];
            ingredientList.add(itemRecipe);
        }
        ShapelessRecipes recipe = new ShapelessRecipes(key, group, CraftItemStack.asNMSCopy((ItemStack)result), NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[ingredientList.size()])));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public String getInternalNameFromMaterial(Material material) {
        return "minecraft:" + CoreUtilities.toLowerCase(material.name());
    }

    @Override
    public Material getMaterialFromInternalName(String internalName) {
        return Material.matchMaterial((String)internalName);
    }

    @Override
    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).B().getChatModifier().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    @Override
    public String getRawHoverText(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "";
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).B().getChatModifier().getHoverEvent().b().getText();
    }

    @Override
    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        NBTTagCompound tag;
        net.minecraft.server.v1_14_R1.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10) && (profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    @Override
    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        net.minecraft.server.v1_14_R1.ItemStack nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        NBTTagCompound tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
        nmsItemStack.setTag(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.server.v1_14_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.setTag(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNbtData(ItemStack itemStack) {
        net.minecraft.server.v1_14_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.hasTag()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.getTag());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    @Override
    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.server.v1_14_R1.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.setTag(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)nmsItemStack);
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles, Color color, boolean icon) {
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    @Override
    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().player == null) {
            ((CraftInventoryPlayer)inventory).getInventory().setItem(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }
}

