/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.util.Vector;

public class MaterialDirectional
implements Property {
    public static final String[] handledMechs = new String[]{"direction"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData().data;
        return data instanceof Directional || data instanceof Orientable;
    }

    public static MaterialDirectional getFrom(ObjectTag _material) {
        if (!MaterialDirectional.describes(_material)) {
            return null;
        }
        return new MaterialDirectional((MaterialTag)_material);
    }

    private MaterialDirectional(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("valid_directions", (attribute, material) -> {
            ListTag toReturn = new ListTag();
            if (material.isOrientable()) {
                for (Axis axis : material.getOrientable().getAxes()) {
                    toReturn.add(axis.name());
                }
            } else {
                for (BlockFace face : material.getDirectional().getFaces()) {
                    toReturn.add(face.name());
                }
            }
            return toReturn;
        }, new String[0]);
        PropertyParser.registerTag("direction", (attribute, material) -> new ElementTag(material.getDirectionName()), new String[0]);
    }

    public Vector getDirectionVector() {
        if (this.isOrientable()) {
            switch (this.getOrientable().getAxis()) {
                case X: {
                    return new Vector(1, 0, 0);
                }
                case Y: {
                    return new Vector(0, 1, 0);
                }
            }
            return new Vector(0, 0, 1);
        }
        if (this.isRotatable()) {
            return this.getRotatable().getRotation().getDirection();
        }
        return this.getDirectional().getFacing().getDirection();
    }

    public String getDirectionName() {
        if (this.isOrientable()) {
            return this.getOrientable().getAxis().name();
        }
        if (this.isRotatable()) {
            return this.getRotatable().getRotation().name();
        }
        return this.getDirectional().getFacing().name();
    }

    public boolean isOrientable() {
        return this.material.getModernData().data instanceof Orientable;
    }

    public boolean isRotatable() {
        return this.material.getModernData().data instanceof Rotatable;
    }

    public boolean isDirectional() {
        return this.material.getModernData().data instanceof Directional;
    }

    public Orientable getOrientable() {
        return (Orientable)this.material.getModernData().data;
    }

    public Rotatable getRotatable() {
        return (Rotatable)this.material.getModernData().data;
    }

    public Directional getDirectional() {
        return (Directional)this.material.getModernData().data;
    }

    public void setFacing(BlockFace face) {
        if (this.isOrientable()) {
            Vector vec = face.getDirection();
            Axis axis = vec.getX() >= 0.5 ? Axis.X : (vec.getY() >= 0.5 ? Axis.Y : Axis.Z);
            this.getOrientable().setAxis(axis);
        } else if (this.isRotatable()) {
            this.getRotatable().setRotation(face);
        } else if (this.isDirectional()) {
            this.getDirectional().setFacing(face);
        }
    }

    @Override
    public String getPropertyString() {
        return this.getDirectionName();
    }

    @Override
    public String getPropertyId() {
        return "direction";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("direction")) {
            if (this.isOrientable() && mechanism.requireEnum(false, (Enum<?>[])Axis.values())) {
                this.getOrientable().setAxis(Axis.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (mechanism.requireEnum(false, (Enum<?>[])BlockFace.values())) {
                this.setFacing(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                Debug.echoError("MaterialTag.Direction mechanism has bad input: directional value '" + mechanism.getValue().asString() + "' is invalid.");
            }
        }
    }
}

