/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ZapCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("step") && arg.hasPrefix() && arg.getPrefix().matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.getPrefix().asType(ScriptTag.class));
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && !arg.matchesPrefix("step")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("step")) {
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("script", scriptEntry.getScript());
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final ScriptTag script = (ScriptTag)scriptEntry.getObject("script");
        DurationTag duration = (DurationTag)scriptEntry.getObject("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), Utilities.getEntryPlayer(scriptEntry).debug() + script.debug() + (scriptEntry.hasObject("step") ? scriptEntry.getElement("step").debug() : ArgumentHelper.debugObj("step", "++ (inc)")) + (duration != null ? duration.debug() : ""));
        }
        String step = scriptEntry.hasObject("step") ? scriptEntry.getElement("step").asString() : null;
        String currentStep = InteractScriptHelper.getCurrentStep(Utilities.getEntryPlayer(scriptEntry), script.getName());
        if (step == null) {
            step = ArgumentHelper.matchesInteger(currentStep) ? String.valueOf(Integer.parseInt(currentStep) + 1) : "1";
        }
        if (step.equalsIgnoreCase(currentStep)) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Zapping to own current step!");
            return;
        }
        final String durationKey = Utilities.getEntryPlayer(scriptEntry).getSaveName() + "," + script.getName();
        Integer durationObj = durations.get(durationKey);
        if (durationObj != null) {
            try {
                DenizenAPI.getCurrentInstance().getServer().getScheduler().cancelTask(durationObj.intValue());
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
        }
        if (duration != null && duration.getSeconds() > 0.0) {
            scriptEntry.addObject("step", new ElementTag(currentStep));
            scriptEntry.addObject("duration", DurationTag.ZERO);
            long delay = (long)(duration.getSeconds() * 20.0);
            Debug.log("Setting delayed task 'RESET ZAP' for '" + script.identify() + "'");
            durations.put(durationKey, DenizenAPI.getCurrentInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    Debug.log("Running delayed task 'RESET ZAP' for '" + script.identify() + "'");
                    durations.remove(durationKey);
                    ZapCommand.this.execute(scriptEntry);
                }
            }, delay));
        }
        DenizenAPI.getCurrentInstance().getSaves().set("Players." + Utilities.getEntryPlayer(scriptEntry).getSaveName() + ".Scripts." + script.getName().toUpperCase() + ".Current Step", (Object)step);
    }
}

