/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Location;

public class AnchorCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("range") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Double) && arg.matchesPrefix("range", "r")) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id", "i")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an 'Anchor Action'. Valid: " + Arrays.asList(Action.values()));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        ElementTag range = (ElementTag)scriptEntry.getObject("range");
        ElementTag id = (ElementTag)scriptEntry.getObject("id");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), npc.debug() + action.name() + id.debug() + (location != null ? location.debug() : "") + (range != null ? range.debug() : ""));
        }
        if (!npc.getCitizen().hasTrait(Anchors.class)) {
            npc.getCitizen().addTrait(Anchors.class);
        }
        switch (action) {
            case ADD: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).addAnchor(id.asString(), (Location)location);
                return;
            }
            case ASSUME: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getEntity().teleport(n.getLocation());
                }
                return;
            }
            case WALKNEAR: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else if (range == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a range!");
                } else {
                    npc.getNavigator().setTarget(Utilities.getWalkableLocationNear(n.getLocation(), range.asInt()));
                }
                return;
            }
            case WALKTO: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getNavigator().setTarget(n.getLocation());
                }
                return;
            }
            case REMOVE: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                    break;
                }
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).removeAnchor(n);
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        ASSUME,
        WALKTO,
        WALKNEAR;

    }
}

