/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Location;

public class StrikeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matches("no_damage") || arg.matches("nodamage")) {
                scriptEntry.addObject("damage", new ElementTag(false));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("damage", new ElementTag(true));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        Boolean damage = scriptEntry.getElement("damage").asBoolean();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), location.debug() + ArgumentHelper.debugObj("Damageable", String.valueOf(damage)));
        }
        if (damage.booleanValue()) {
            location.getWorld().strikeLightning((Location)location);
        } else {
            location.getWorld().strikeLightningEffect((Location)location);
        }
    }
}

