/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.server.ScoreboardCommand;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Argument;
import com.google.common.base.Splitter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class ScoreboardHelper {
    public static ScoreboardManager manager = Bukkit.getScoreboardManager();
    public static Map<String, Scoreboard> scoreboardMap = new HashMap<String, Scoreboard>();
    public static Map<String, String> viewerMap = new HashMap<String, String>();

    public static void _recallScoreboards() {
        for (Map.Entry<String, Scoreboard> entry : scoreboardMap.entrySet()) {
            ScoreboardHelper.clearScoreboard(entry.getValue());
        }
        Scoreboard emptyBoard = ScoreboardHelper.createScoreboard();
        for (Map.Entry<String, String> entry : viewerMap.entrySet()) {
            OfflinePlayer player = ScoreboardCommand.getOfflinePlayer(entry.getKey());
            if (!player.isOnline()) continue;
            player.getPlayer().setScoreboard(emptyBoard);
        }
        scoreboardMap.clear();
        viewerMap.clear();
        ConfigurationSection configurationSection = DenizenAPI.getCurrentInstance().getScoreboards().getConfigurationSection("Scoreboards");
        if (configurationSection == null) {
            return;
        }
        Object var2_5 = null;
        for (String id : configurationSection.getKeys(false)) {
            Scoreboard scoreboard = ScoreboardHelper.createScoreboard(id);
            List viewerList = configurationSection.getStringList(id + ".Viewers");
            for (String viewer : viewerList) {
                if (!PlayerTag.matches(viewer)) continue;
                PlayerTag player = PlayerTag.valueOf(viewer);
                viewerMap.put(player.getName(), id);
                if (!player.isOnline()) continue;
                player.getPlayerEntity().setScoreboard(scoreboard);
            }
            ConfigurationSection objSection = configurationSection.getConfigurationSection(id + ".Objectives");
            if (objSection == null) {
                return;
            }
            for (String obj : objSection.getKeys(false)) {
                ConfigurationSection scoreSection;
                String displaySlot = objSection.getString(obj + ".Display slot");
                String criteria = objSection.getString(obj + ".Criteria");
                if (criteria == null) {
                    criteria = "dummy";
                }
                if (displaySlot == null) {
                    displaySlot = "NONE";
                }
                Objective o = scoreboard.registerNewObjective(obj, criteria);
                o.setDisplayName(obj);
                if (Argument.valueOf(displaySlot).matchesEnum((Enum<?>[])DisplaySlot.values())) {
                    o.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.toUpperCase()));
                }
                if ((scoreSection = objSection.getConfigurationSection(obj + ".Scores")) == null) continue;
                for (String scoreName : scoreSection.getKeys(false)) {
                    int scoreInt = scoreSection.getInt(scoreName);
                    ScoreboardHelper.addScore(o, ScoreboardCommand.getOfflinePlayer(scoreName), scoreInt);
                }
            }
        }
    }

    public static void _saveScoreboards() {
        try {
            DenizenAPI.getCurrentInstance().getScoreboards().set("Scoreboards", null);
            for (Map.Entry<String, Scoreboard> scoreboardEntry : scoreboardMap.entrySet()) {
                String id = scoreboardEntry.getKey();
                ArrayList<String> viewerList = new ArrayList<String>();
                for (Map.Entry<String, String> viewerEntry : viewerMap.entrySet()) {
                    if (!id.equalsIgnoreCase(viewerEntry.getValue())) continue;
                    viewerList.add(viewerEntry.getKey());
                }
                DenizenAPI.getCurrentInstance().getScoreboards().set("Scoreboards." + id + ".Viewers", viewerList);
                for (Objective obj : scoreboardEntry.getValue().getObjectives()) {
                    String objPath = "Scoreboards." + id + ".Objectives." + obj.getName();
                    DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Criteria", (Object)obj.getCriteria());
                    String displaySlot = obj.getDisplaySlot() != null ? obj.getDisplaySlot().name() : "NONE";
                    DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Display slot", (Object)displaySlot);
                    for (String player : scoreboardEntry.getValue().getEntries()) {
                        int score = obj.getScore(player).getScore();
                        Team team = scoreboardEntry.getValue().getTeam(player);
                        player = (team != null && team.getPrefix() != null ? team.getPrefix() : "") + player + (team != null && team.getSuffix() != null ? team.getSuffix() : "");
                        if (score == 0) continue;
                        DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Scores." + player, (Object)score);
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    public static void addScore(Objective o, OfflinePlayer player, int score) {
        Score sc;
        if (player.getName().length() <= 16) {
            sc = o.getScore(player.getName());
        } else {
            Map.Entry<Team, String> teamData = ScoreboardHelper.createTeam(o.getScoreboard(), player.getName());
            sc = o.getScore(teamData.getValue());
            teamData.getKey().addPlayer(ScoreboardCommand.getOfflinePlayer(teamData.getValue()));
        }
        if (score == 0) {
            sc.setScore(1);
            sc.setScore(0);
        } else {
            sc.setScore(score);
        }
    }

    public static void removeScore(Objective o, OfflinePlayer player) {
        Scoreboard board = o.getScoreboard();
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        String name = ScoreboardHelper.createTeam(board, player.getName()).getValue();
        for (Score score : board.getScores(name)) {
            if (score.getObjective().equals(o)) continue;
            scoreMap.put(score.getObjective().getName(), score.getScore());
        }
        board.resetScores(player.getName());
        for (Map.Entry entry : scoreMap.entrySet()) {
            board.getObjective((String)entry.getKey()).getScore(player.getName()).setScore(((Integer)entry.getValue()).intValue());
        }
    }

    private static Map.Entry<Team, String> createTeam(Scoreboard scoreboard, String text) {
        if (text.length() <= 16) {
            return new AbstractMap.SimpleEntry<Object, String>(null, text);
        }
        if (text.length() <= 32) {
            Team team = scoreboard.registerNewTeam("text-" + scoreboard.getTeams().size());
            team.setPrefix(text.substring(0, text.length() - 16));
            String result = text.substring(text.length() - 16);
            return new AbstractMap.SimpleEntry<Team, String>(team, result);
        }
        Team team = scoreboard.registerNewTeam("text-" + scoreboard.getTeams().size());
        Iterator iterator = Splitter.fixedLength((int)16).split((CharSequence)text).iterator();
        team.setPrefix((String)iterator.next());
        String result = (String)iterator.next();
        if (text.length() > 32) {
            team.setSuffix((String)iterator.next());
        }
        return new AbstractMap.SimpleEntry<Team, String>(team, result);
    }

    public static void clearScoreboard(Scoreboard board) {
        for (Objective o : board.getObjectives()) {
            o.unregister();
        }
    }

    public static Scoreboard createScoreboard() {
        return manager.getNewScoreboard();
    }

    public static Scoreboard createScoreboard(String id) {
        Scoreboard board = manager.getNewScoreboard();
        scoreboardMap.put(id.toUpperCase(), board);
        return board;
    }

    public static void deleteScoreboard(String id) {
        if (id.equalsIgnoreCase("main")) {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getMain());
        } else {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getScoreboard(id));
            scoreboardMap.remove(id.toUpperCase());
        }
    }

    public static Scoreboard getMain() {
        return manager.getMainScoreboard();
    }

    public static Scoreboard getScoreboard(String id) {
        return scoreboardMap.get(id.toUpperCase());
    }

    public static boolean hasScoreboard(String id) {
        return scoreboardMap.containsKey(id.toUpperCase());
    }

    public static void removePlayer(String id, OfflinePlayer player) {
        scoreboardMap.get(id.toUpperCase()).resetScores(player.getName());
    }
}

