/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class VehicleCollidesEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleCollidesEntityScriptEvent instance;
    public EntityTag vehicle;
    public EntityTag entity;
    private Boolean pickup_cancel;
    public VehicleEntityCollisionEvent event;

    public VehicleCollidesEntityScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("collides with");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.vehicle, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "VehicleCollidesEntity";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        Argument arg;
        if (determinationObj instanceof ElementTag && (arg = Argument.valueOf(determinationObj.toString())).matchesPrefix("pickup")) {
            this.pickup_cancel = !arg.asElement().asBoolean();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("pickup")) {
            return new ElementTag(this.pickup_cancel == false);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleCollidesEntity(VehicleEntityCollisionEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.pickup_cancel = event.isPickupCancelled();
        this.event = event;
        this.fire((Event)event);
        event.setPickupCancelled(this.pickup_cancel.booleanValue());
    }
}

