/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class ItemRecipeFormedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemRecipeFormedScriptEvent instance;
    public PrepareItemCraftEvent event;
    public ItemTag result;

    public ItemRecipeFormedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(1).equals("crafted")) {
            return true;
        }
        return path.eventArgLowerAt(1).equals("recipe") && path.eventArgLowerAt(2).equals("formed");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String eItem = path.eventArgLowerAt(0);
        if (!this.tryItem(this.result, eItem)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ItemRecipeFormed";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            ItemTag result = ItemTag.valueOf(determination, path.container);
            this.event.getInventory().setResult(result.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)this.event.getView().getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            Recipe eRecipe = this.event.getRecipe();
            return new ItemTag(eRecipe.getResult());
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
        }
        if (name.equals("recipe")) {
            ListTag recipe = new ListTag();
            for (ItemStack itemStack : this.event.getInventory().getMatrix()) {
                if (itemStack != null && itemStack.getType() != Material.AIR) {
                    recipe.addObject(new ItemTag(itemStack));
                    continue;
                }
                recipe.addObject(new ItemTag(Material.AIR));
            }
            return recipe;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onRecipeFormed(PrepareItemCraftEvent event) {
        this.event = event;
        Recipe eRecipe = event.getRecipe();
        if (eRecipe == null || eRecipe.getResult() == null) {
            return;
        }
        this.result = new ItemTag(eRecipe.getResult());
        this.cancelled = false;
        this.fire((Event)event);
        if (this.cancelled) {
            event.getInventory().setResult(null);
        }
    }
}

