/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.impl.network.handlers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.v1_15.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_15.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_15.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.handlers.FakeBlockHelper;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutChatImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutEntityMetadataImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutSetSlotImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutSpawnEntityImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutTradeListImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.packets.PacketOutWindowItemsImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.EnumProtocol;
import net.minecraft.server.v1_15_R1.EnumProtocolDirection;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.MathHelper;
import net.minecraft.server.v1_15_R1.NetworkManager;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketListener;
import net.minecraft.server.v1_15_R1.PacketPlayOutBlockBreak;
import net.minecraft.server.v1_15_R1.PacketPlayOutBlockChange;
import net.minecraft.server.v1_15_R1.PacketPlayOutChat;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntity;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_15_R1.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_15_R1.PacketPlayOutMapChunk;
import net.minecraft.server.v1_15_R1.PacketPlayOutMultiBlockChange;
import net.minecraft.server.v1_15_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenWindowMerchant;
import net.minecraft.server.v1_15_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_15_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntityPainting;
import net.minecraft.server.v1_15_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public final DenizenPacketHandler packetHandler;
    public static Field ENTITY_ID_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("a");
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get("a");
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("a");
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("b");
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("c");
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("d");
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("b");
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("c");
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("d");
    public static Field BLOCKPOS_BLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutBlockChange.class).get("a");
    public static Field CHUNKCOORD_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get("a");
    public static Field INFOARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get("b");
    public static Field CHUNKX_MAPCHUNK = ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get("a");
    public static Field CHUNKZ_MAPCHUNK = ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get("b");
    public static Field BLOCKPOS_BLOCKBREAK = ReflectionHelper.getFields(PacketPlayOutBlockBreak.class).get("c");
    public static Field BLOCKDATA_BLOCKBREAK = ReflectionHelper.getFields(PacketPlayOutBlockBreak.class).get("d");
    private static final Field protocolDirectionField;
    private static final MethodHandle networkManagerField;

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager, DenizenPacketHandler packetHandler) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.channel = oldManager.channel;
        this.packetListener = new DenizenPacketListenerImpl(this, entityPlayer);
        oldManager.setPacketListener((PacketListener)this.packetListener);
        this.player = this.packetListener.player;
        this.packetHandler = packetHandler;
    }

    public static void setNetworkManager(Player player, DenizenPacketHandler packetHandler) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.playerConnection;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, playerConnection.networkManager, packetHandler));
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void setProtocol(EnumProtocol enumprotocol) {
        this.oldManager.setProtocol(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet packet) throws Exception {
        if (this.oldManager.channel.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPacketListener(PacketListener packetlistener) {
        this.oldManager.setPacketListener(packetlistener);
    }

    public static Object duplo(Object a2) {
        try {
            Class<?> clazz = a2.getClass();
            Object reter = clazz.newInstance();
            for (Field f : clazz.getDeclaredFields()) {
                f.setAccessible(true);
                f.set(reter, f.get(a2));
            }
            Class<?> subc = clazz;
            while (subc.getSuperclass() != null) {
                subc = subc.getSuperclass();
                for (Field f : subc.getDeclaredFields()) {
                    f.setAccessible(true);
                    f.set(reter, f.get(a2));
                }
            }
            return reter;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public void sendPacket(Packet<?> packet) {
        this.sendPacket(packet, null);
    }

    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (NMSHandler.debugPackets) {
            Debug.log("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.getName());
        }
        if (this.processAttachToForPacket(packet) || this.processHiddenEntitiesForPacket(packet) || this.processPacketHandlerForPacket(packet) || this.processMirrorForPacket(packet)) {
            return;
        }
        this.processMirrorForPacket(packet);
        this.processShowFakeForPacket(packet);
        this.processBlockLightForPacket(packet);
        this.oldManager.sendPacket(packet, genericfuturelistener);
    }

    public boolean shouldSendAttachOriginal(net.minecraft.server.v1_15_R1.Entity e) {
        UUID attached = NMSHandler.getInstance().attachmentsA.get(e.getUniqueID());
        return attached != null && !attached.equals(this.player.getUniqueID());
    }

    public boolean processAttachToForPacket(Packet<?> packet) {
        try {
            if (packet instanceof PacketPlayOutEntity) {
                Entity target;
                int ider = ENTITY_ID_PACKENT.getInt(packet);
                net.minecraft.server.v1_15_R1.Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                UUID att = NMSHandler.getInstance().attachments2.get(e.getUniqueID());
                if (att != null && (target = Bukkit.getEntity((UUID)att)) != null) {
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKENT.setInt(pNew, target.getEntityId());
                    Vector offset = NMSHandler.getInstance().attachmentOffsets.get(att);
                    if (offset != null && (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove || packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook)) {
                        boolean rotationBasis = NMSHandler.getInstance().attachmentRotations.contains(att);
                        Vector goalPosition = !rotationBasis ? new Vector(e.locX(), e.locY(), e.locZ()).add(offset) : new Vector(e.locX(), e.locY(), e.locZ()).add(NMSHandler.fixOffset(offset, -e.yaw, e.pitch));
                        Vector oldPos = NMSHandler.getInstance().visiblePositions.get(target.getUniqueId());
                        if (oldPos == null) {
                            oldPos = target.getLocation().toVector();
                        }
                        Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                        NMSHandler.getInstance().visiblePositions.put(target.getUniqueId(), goalPosition.clone());
                        int offX = (int)(moveNeeded.getX() * 4096.0);
                        int offY = (int)(moveNeeded.getY() * 4096.0);
                        int offZ = (int)(moveNeeded.getZ() * 4096.0);
                        if (offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                            PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e);
                            ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, target.getEntityId());
                            POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                            POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                            POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                            this.oldManager.sendPacket((Packet)newTeleportPacket);
                        } else {
                            POS_X_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                            POS_Y_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                            POS_Z_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                            this.oldManager.sendPacket(pNew);
                        }
                    } else {
                        this.oldManager.sendPacket(pNew);
                    }
                }
                return this.shouldSendAttachOriginal(e);
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                Entity target;
                int ider = ENTITY_ID_PACKVELENT.getInt(packet);
                net.minecraft.server.v1_15_R1.Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                UUID att = NMSHandler.getInstance().attachments2.get(e.getUniqueID());
                if (att != null && (target = Bukkit.getEntity((UUID)att)) != null) {
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKVELENT.setInt(pNew, target.getEntityId());
                    this.oldManager.sendPacket(pNew);
                }
                return this.shouldSendAttachOriginal(e);
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                Entity target;
                int ider = ENTITY_ID_PACKTELENT.getInt(packet);
                net.minecraft.server.v1_15_R1.Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                UUID att = NMSHandler.getInstance().attachments2.get(e.getUniqueID());
                if (att != null && (target = Bukkit.getEntity((UUID)att)) != null) {
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKTELENT.setInt(pNew, target.getEntityId());
                    Vector offset = NMSHandler.getInstance().attachmentOffsets.get(att);
                    Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew));
                    if (offset != null) {
                        boolean rotationBasis = NMSHandler.getInstance().attachmentRotations.contains(att);
                        Vector goalOffset = !rotationBasis ? offset : NMSHandler.fixOffset(offset, -e.yaw, e.pitch);
                        POS_X_PACKTELENT.setDouble(pNew, POS_X_PACKTELENT.getDouble(pNew) + goalOffset.getX());
                        POS_Y_PACKTELENT.setDouble(pNew, POS_Y_PACKTELENT.getDouble(pNew) + goalOffset.getY());
                        POS_Z_PACKTELENT.setDouble(pNew, POS_Z_PACKTELENT.getDouble(pNew) + goalOffset.getZ());
                        resultPos.add(goalOffset);
                    }
                    NMSHandler.getInstance().visiblePositions.put(target.getUniqueId(), resultPos);
                    this.oldManager.sendPacket(pNew);
                }
                return this.shouldSendAttachOriginal(e);
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean isHidden(net.minecraft.server.v1_15_R1.Entity entity) {
        return entity != null && NMSHandler.getEntityHelper().isHidden((Player)this.player.getBukkitEntity(), (Entity)entity.getBukkitEntity());
    }

    public boolean processHiddenEntitiesForPacket(Packet<?> packet) {
        try {
            net.minecraft.server.v1_15_R1.Entity e;
            if (packet instanceof PacketPlayOutNamedEntitySpawn || packet instanceof PacketPlayOutSpawnEntity || packet instanceof PacketPlayOutSpawnEntityLiving || packet instanceof PacketPlayOutSpawnEntityPainting || packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                PacketOutSpawnEntityImpl spawnEntity = new PacketOutSpawnEntityImpl(this.player, packet);
                net.minecraft.server.v1_15_R1.Entity entity = this.player.getWorld().getEntity(spawnEntity.getEntityId());
                if (this.isHidden(entity)) {
                    return true;
                }
                this.processFakePlayerSpawn(entity);
            }
            if (packet instanceof PacketPlayOutEntity) {
                int ider = ENTITY_ID_PACKENT.getInt(packet);
                e = this.player.getWorld().getEntity(ider);
                if (this.isHidden(e)) {
                    return true;
                }
            } else if (packet instanceof PacketPlayOutEntityVelocity) {
                int ider = ENTITY_ID_PACKVELENT.getInt(packet);
                e = this.player.getWorld().getEntity(ider);
                if (this.isHidden(e)) {
                    return true;
                }
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                int ider = ENTITY_ID_PACKTELENT.getInt(packet);
                e = this.player.getWorld().getEntity(ider);
                if (this.isHidden(e)) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public void processFakePlayerSpawn(net.minecraft.server.v1_15_R1.Entity entity) {
        if (entity instanceof EntityFakePlayerImpl) {
            EntityFakePlayerImpl fakePlayer = (EntityFakePlayerImpl)entity;
            this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{fakePlayer}));
            Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{fakePlayer})), 5L);
        }
    }

    public boolean processMirrorForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutPlayerInfo) {
            PacketPlayOutPlayerInfo playerInfo = (PacketPlayOutPlayerInfo)packet;
            if (!ProfileEditorImpl.handleMirrorProfiles(playerInfo, this)) {
                return true;
            }
            ProfileEditorImpl.updatePlayerProfiles(playerInfo);
        }
        return false;
    }

    public boolean processPacketHandlerForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutChat) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutChatImpl((PacketPlayOutChat)packet));
        }
        if (packet instanceof PacketPlayOutEntityMetadata) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutEntityMetadataImpl((PacketPlayOutEntityMetadata)packet));
        }
        if (packet instanceof PacketPlayOutSetSlot) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutSetSlotImpl((PacketPlayOutSetSlot)packet));
        }
        if (packet instanceof PacketPlayOutWindowItems) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutWindowItemsImpl((PacketPlayOutWindowItems)packet));
        }
        if (packet instanceof PacketPlayOutOpenWindowMerchant) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutTradeListImpl((PacketPlayOutOpenWindowMerchant)packet));
        }
        return false;
    }

    public void processShowFakeForPacket(Packet<?> packet) {
        try {
            if (packet instanceof PacketPlayOutMapChunk) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.getUniqueID());
                if (map == null) {
                    return;
                }
                int chunkX = CHUNKX_MAPCHUNK.getInt(packet);
                int chunkZ = CHUNKZ_MAPCHUNK.getInt(packet);
                ChunkCoordinate chunkCoord = new ChunkCoordinate(chunkX, chunkZ, this.player.getWorld().getWorld().getName());
                List<FakeBlock> blocks = FakeBlock.getFakeBlocksFor(this.player.getUniqueID(), chunkCoord);
                if (blocks == null) {
                    return;
                }
                FakeBlockHelper.handleMapChunkPacket((PacketPlayOutMapChunk)packet, blocks);
            } else if (packet instanceof PacketPlayOutMultiBlockChange) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.getUniqueID());
                if (map == null) {
                    return;
                }
                ChunkCoordIntPair coord = (ChunkCoordIntPair)CHUNKCOORD_MULTIBLOCKCHANGE.get(packet);
                ChunkCoordinate coordinateDenizen = new ChunkCoordinate(coord.x, coord.z, this.player.getWorld().getWorld().getName());
                if (!map.byChunk.containsKey(coordinateDenizen)) {
                    return;
                }
                LocationTag location = new LocationTag((World)this.player.getWorld().getWorld(), 0.0, 0.0, 0.0);
                PacketPlayOutMultiBlockChange.MultiBlockChangeInfo[] changeArr = (PacketPlayOutMultiBlockChange.MultiBlockChangeInfo[])INFOARRAY_MULTIBLOCKCHANGE.get(packet);
                for (int i = 0; i < changeArr.length; ++i) {
                    short blockInd = changeArr[i].b();
                    int x = blockInd & 0xF0;
                    int y = (blockInd & 0xFF) >> 8;
                    int z = (blockInd & 0xF) >> 4;
                    location.setX((coord.x << 4) + x);
                    location.setY(y);
                    location.setZ((coord.z << 4) + z);
                    FakeBlock block = map.byLocation.get(location);
                    if (block == null) continue;
                    PacketPlayOutMultiBlockChange packetPlayOutMultiBlockChange = (PacketPlayOutMultiBlockChange)packet;
                    packetPlayOutMultiBlockChange.getClass();
                    changeArr[i] = new PacketPlayOutMultiBlockChange.MultiBlockChangeInfo(packetPlayOutMultiBlockChange, blockInd, FakeBlockHelper.getNMSState(block));
                }
            } else if (packet instanceof PacketPlayOutBlockChange) {
                BlockPosition pos = (BlockPosition)BLOCKPOS_BLOCKCHANGE.get(packet);
                LocationTag loc = new LocationTag((World)this.player.getWorld().getWorld(), (double)pos.getX(), (double)pos.getY(), pos.getZ());
                FakeBlock block = FakeBlock.getFakeBlockFor(this.player.getUniqueID(), loc);
                if (block != null) {
                    ((PacketPlayOutBlockChange)packet).block = FakeBlockHelper.getNMSState(block);
                }
            } else if (packet instanceof PacketPlayOutBlockBreak) {
                BlockPosition pos = (BlockPosition)BLOCKPOS_BLOCKBREAK.get(packet);
                LocationTag loc = new LocationTag((World)this.player.getWorld().getWorld(), (double)pos.getX(), (double)pos.getY(), pos.getZ());
                FakeBlock block = FakeBlock.getFakeBlockFor(this.player.getUniqueID(), loc);
                if (block != null) {
                    BLOCKDATA_BLOCKBREAK.set(packet, FakeBlockHelper.getNMSState(block));
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
    }

    public void processBlockLightForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutLightUpdate) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutLightUpdate)packet, this.player.world);
        } else if (packet instanceof PacketPlayOutBlockChange) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutBlockChange)packet, this.player.world);
        }
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress getSocketAddress() {
        return this.oldManager.getSocketAddress();
    }

    public void close(IChatBaseComponent ichatbasecomponent) {
        this.oldManager.close(ichatbasecomponent);
    }

    public boolean isLocal() {
        return this.oldManager.isLocal();
    }

    public void a(SecretKey secretkey) {
        this.oldManager.a(secretkey);
    }

    public boolean isConnected() {
        return this.oldManager.isConnected();
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public PacketListener i() {
        return this.oldManager.i();
    }

    public IChatBaseComponent j() {
        return this.oldManager.j();
    }

    public void stopReading() {
        this.oldManager.stopReading();
    }

    public void setCompressionLevel(int i) {
        this.oldManager.setCompressionLevel(i);
    }

    public void handleDisconnection() {
        this.oldManager.handleDisconnection();
    }

    public SocketAddress getRawAddress() {
        return this.oldManager.getRawAddress();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            networkManagerField.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    static {
        Field directionField = null;
        MethodHandle managerField = null;
        try {
            directionField = NetworkManager.class.getDeclaredField("h");
            directionField.setAccessible(true);
            managerField = ReflectionHelper.getFinalSetter(PlayerConnection.class, "networkManager");
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        protocolDirectionField = directionField;
        networkManagerField = managerField;
    }
}

