/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;

public class EntitySpeed
implements Property {
    public static final String[] handledTags = new String[]{"speed"};
    public static final String[] handledMechs = new String[]{"speed"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        EntityTag ent = (EntityTag)entity;
        if (ent.isLivingEntity()) {
            return true;
        }
        EntityType entityType = ent.getBukkitEntityType();
        return entityType == EntityType.BOAT || entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT;
    }

    public static EntitySpeed getFrom(ObjectTag entity) {
        if (!EntitySpeed.describes(entity)) {
            return null;
        }
        return new EntitySpeed((EntityTag)entity);
    }

    private EntitySpeed(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.getSpeed().asString();
    }

    @Override
    public String getPropertyId() {
        return "speed";
    }

    public ElementTag getSpeed() {
        if (this.entity.isLivingEntity()) {
            return new ElementTag(NMSHandler.getEntityHelper().getSpeed(this.entity.getBukkitEntity()));
        }
        EntityType entityType = this.entity.getBukkitEntityType();
        if (entityType == EntityType.BOAT) {
            return new ElementTag(((Boat)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        if (entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT) {
            return new ElementTag(((Minecart)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        return new ElementTag(0.0);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("speed")) {
            return this.getSpeed().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("speed") && mechanism.requireDouble()) {
            double value = mechanism.getValue().asDouble();
            if (this.entity.isLivingEntity()) {
                NMSHandler.getEntityHelper().setSpeed(this.entity.getBukkitEntity(), value);
            } else {
                EntityType entityType = this.entity.getBukkitEntityType();
                if (entityType == EntityType.BOAT) {
                    ((Boat)this.entity.getBukkitEntity()).setMaxSpeed(value);
                } else if (entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT) {
                    ((Minecart)this.entity.getBukkitEntity()).setMaxSpeed(value);
                }
            }
        }
    }
}

