/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class GlowCommand
extends AbstractCommand {
    public static HashMap<Integer, HashSet<UUID>> glowViewers = new HashMap();

    public static void unGlow(LivingEntity e) {
        if (glowViewers.containsKey(e.getEntityId())) {
            glowViewers.remove(e.getEntityId());
            e.setGlowing(false);
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)e)) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)e).data().setPersistent("glowing", (Object)false);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("glowing") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Boolean)) {
                scriptEntry.addObject("glowing", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("glowing", new ElementTag("true"));
        if (!Utilities.entryHasPlayer(scriptEntry)) {
            throw new InvalidArgumentsException("Must have a valid player link!");
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entities to make glow!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ArrayList entities = (ArrayList)scriptEntry.getObject("entities");
        ElementTag glowing = scriptEntry.getElement("glowing");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugList("entities", entities) + glowing.debug());
        }
        boolean shouldGlow = glowing.asBoolean();
        UUID puuid = Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer().getUniqueId();
        if (puuid == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Invalid/non-spawned player link!");
            return;
        }
        for (EntityTag ent : entities) {
            HashSet<UUID> players;
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)ent.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)ent.getLivingEntity()).data().setPersistent("glowing", (Object)shouldGlow);
            }
            if (shouldGlow) {
                players = glowViewers.get(ent.getLivingEntity().getEntityId());
                if (players == null) {
                    players = new HashSet();
                    glowViewers.put(ent.getLivingEntity().getEntityId(), players);
                }
                players.add(puuid);
            } else {
                players = glowViewers.get(ent.getLivingEntity().getEntityId());
                if (players != null) {
                    players.remove(puuid);
                    boolean bl = shouldGlow = !players.isEmpty();
                    if (!shouldGlow) {
                        glowViewers.remove(ent.getLivingEntity().getEntityId());
                    }
                }
            }
            ent.getLivingEntity().setGlowing(shouldGlow);
        }
    }
}

