/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookScriptContainer
extends ScriptContainer {
    public BookScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public ItemTag getBookFrom() {
        return this.getBookFrom(null);
    }

    public ItemTag getBookFrom(BukkitTagContext context) {
        ItemTag stack = new ItemTag(Material.WRITTEN_BOOK);
        return this.writeBookTo(stack, context);
    }

    public ItemTag writeBookTo(ItemTag book, BukkitTagContext context) {
        if (context == null) {
            context = new BukkitTagContext(null, null, new ScriptTag(this));
        }
        BookMeta bookInfo = (BookMeta)book.getItemStack().getItemMeta();
        if (this.contains("title")) {
            String title = this.getString("title");
            title = TagManager.tag(title, context);
            bookInfo.setTitle(title);
        }
        if (this.contains("signed") && this.getString("signed").equalsIgnoreCase("false")) {
            book.getItemStack().setType(MaterialCompat.WRITABLE_BOOK);
        }
        if (this.contains("author")) {
            String author = this.getString("author");
            author = TagManager.tag(author, context);
            bookInfo.setAuthor(author);
        }
        if (this.contains("text")) {
            List<String> pages = this.getStringList("text");
            for (String page : pages) {
                page = TagManager.tag(page, context);
                bookInfo.spigot().addPage((BaseComponent[][])new BaseComponent[][]{FormattedTextHelper.parse(page)});
            }
        }
        book.getItemStack().setItemMeta((ItemMeta)bookInfo);
        return book;
    }
}

