/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DataPersistenceHelper {
    public static final DenizenObjectType PERSISTER_TYPE = new DenizenObjectType();

    public static void setDenizenKey(Entity entity, String keyName, ObjectTag keyValue) {
        entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE, (Object)keyValue);
    }

    public static boolean hasDenizenKey(Entity entity, String keyName) {
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
    }

    public static ObjectTag getDenizenKey(Entity entity, String keyName) {
        try {
            return (ObjectTag)entity.getPersistentDataContainer().get(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            Debug.echoError("Failed to read ObjectTag from entity key '" + keyName + "' for entity " + entity.getUniqueId() + "...");
            Debug.echoError(ex);
            return null;
        }
    }

    public static class DenizenObjectType
    implements PersistentDataType<String, ObjectTag> {
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<ObjectTag> getComplexType() {
            return ObjectTag.class;
        }

        public String toPrimitive(ObjectTag complex, PersistentDataAdapterContext context) {
            return complex.toString();
        }

        public ObjectTag fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return ObjectFetcher.pickObjectFor(primitive);
        }
    }
}

