/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.implementation;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.entity.Entity;

public class BukkitScriptEntryData
extends ScriptEntryData {
    private PlayerTag player;
    private NPCTag npc;

    public BukkitScriptEntryData(PlayerTag player, NPCTag npc) {
        this.player = player;
        this.npc = npc;
    }

    public BukkitScriptEntryData(EntityTag entity) {
        if (entity == null) {
            return;
        }
        if (entity.isCitizensNPC()) {
            this.npc = entity.getDenizenNPC();
        }
        if (entity.isPlayer()) {
            this.player = entity.getDenizenPlayer();
        }
    }

    public BukkitScriptEntryData(Entity entity) {
        this(entity == null ? null : new EntityTag(entity));
    }

    public PlayerTag getPlayer() {
        return this.player;
    }

    public NPCTag getNPC() {
        return this.npc != null && this.npc.getCitizen() != null ? this.npc : null;
    }

    public boolean hasNPC() {
        return this.npc != null && this.npc.getCitizen() != null;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public void setPlayer(PlayerTag player) {
        this.player = player;
    }

    public void setNPC(NPCTag npc) {
        this.npc = npc;
    }

    @Override
    public void transferDataFrom(ScriptEntryData scriptEntryData) {
        if (scriptEntryData == null) {
            return;
        }
        this.player = ((BukkitScriptEntryData)scriptEntryData).getPlayer();
        this.npc = ((BukkitScriptEntryData)scriptEntryData).getNPC();
        this.scriptEntry = scriptEntryData.scriptEntry;
    }

    @Override
    public TagContext getTagContext() {
        return new BukkitTagContext(this.player, this.npc, false, this.scriptEntry, this.scriptEntry != null ? this.scriptEntry.shouldDebug() : true, this.scriptEntry != null ? this.scriptEntry.getScript() : null);
    }

    @Override
    public String toString() {
        if (this.npc == null && this.player == null) {
            return "";
        }
        if (this.npc == null) {
            return "player=p@" + this.player.getName();
        }
        if (this.player == null) {
            return "npc=n@" + this.npc.getId();
        }
        return "player=p@" + this.player.getName() + "   npc=n@" + this.npc.getId();
    }
}

