/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class WaitCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("delay")) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(QueueTag.class) && !scriptEntry.hasObject("queue")) {
                scriptEntry.addObject("delay", arg.asType(QueueTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("queue", new QueueTag(scriptEntry.getResidingQueue()));
        scriptEntry.defaultObject("delay", new DurationTag(3));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        QueueTag queue = (QueueTag)scriptEntry.getObject("queue");
        DurationTag delay = (DurationTag)scriptEntry.getObject("delay");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), queue.debug() + delay.debug());
        }
        if (queue.queue instanceof Delayable) {
            ((Delayable)((Object)queue.queue)).delayFor(delay);
        } else {
            scriptEntry.setInstant(false);
            Debug.echoDebug((Debuggable)scriptEntry, "Forcing queue " + queue.queue.id + " into a timed queue...");
            queue.queue.forceToTimed(delay);
        }
    }
}

